/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openconcerto.erp.core.sales.pos.model.TicketLine;

public class TicketLineTableModel
extends AbstractTableModel {
    private final List<TicketLine> list = new ArrayList<TicketLine>();

    TicketLineTableModel() {
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Texte";
        }
        return "Style";
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TicketLine l = this.list.get(rowIndex);
        if (columnIndex == 0) {
            return l.getText();
        }
        return l.getStyle();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (rowIndex >= this.list.size()) {
            return;
        }
        TicketLine l = this.list.get(rowIndex);
        if (columnIndex == 0) {
            l.setText(value.toString());
        } else {
            if (value == null) {
                value = "normal";
            }
            l.setStyle(value.toString());
        }
    }

    public void setContent(List<TicketLine> data) {
        this.list.clear();
        this.list.addAll(data);
    }

    public void removeLine(int i) {
        if (i >= 0 && i < this.list.size()) {
            this.list.remove(i);
        }
        this.fireTableDataChanged();
    }

    public void addLine(int i) {
        if (i >= 0 && i < this.list.size()) {
            this.list.add(i, new TicketLine("--", "normal"));
        } else {
            this.list.add(new TicketLine("--", "normal"));
        }
        this.fireTableDataChanged();
    }

    public List<TicketLine> getLines() {
        return Collections.unmodifiableList(this.list);
    }
}

