/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;

public class AlterTableSet
extends SchemaCommand {
    private String tableName;
    private final int type;
    private boolean checkExisting;

    public AlterTableSet(Session session, Schema schema, int n) {
        super(session, schema);
        this.type = n;
    }

    public void setCheckExisting(boolean bl) {
        this.checkExisting = bl;
    }

    public boolean isTransactional() {
        return true;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public int update() {
        Table table = this.getSchema().getTableOrView(this.session, this.tableName);
        this.session.getUser().checkRight(table, 15);
        table.lock(this.session, true, true);
        switch (this.type) {
            case 0: {
                table.setCheckForeignKeyConstraints(this.session, true, this.checkExisting);
                break;
            }
            case 1: {
                table.setCheckForeignKeyConstraints(this.session, false, false);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return 0;
    }
}

