/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jocl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.jocl.ConstructorUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class JOCLContentHandler
extends DefaultHandler {
    protected ArrayList _typeList = new ArrayList();
    protected ArrayList _valueList = new ArrayList();
    protected ConstructorDetails _cur = null;
    protected boolean _acceptEmptyNamespaceForElements = true;
    protected boolean _acceptJoclPrefixForElements = true;
    protected boolean _acceptEmptyNamespaceForAttributes = true;
    protected boolean _acceptJoclPrefixForAttributes = true;
    protected Locator _locator = null;

    public static JOCLContentHandler parse(InputStream in) throws SAXException, IOException {
        return JOCLContentHandler.parse(new InputSource(in), null);
    }

    public static JOCLContentHandler parse(InputSource in, XMLReader reader) throws SAXException, IOException {
        JOCLContentHandler jocl = new JOCLContentHandler();
        if (null == reader) {
            reader = XMLReaderFactory.createXMLReader();
        }
        reader.setContentHandler(jocl);
        reader.parse(in);
        return jocl;
    }

    public JOCLContentHandler() {
        this(true, true, true, true);
    }

    public JOCLContentHandler(boolean emptyEltNS, boolean joclEltPrefix, boolean emptyAttrNS, boolean joclAttrPrefix) {
        this._acceptEmptyNamespaceForElements = emptyEltNS;
        this._acceptJoclPrefixForElements = joclEltPrefix;
        this._acceptEmptyNamespaceForAttributes = emptyAttrNS;
        this._acceptJoclPrefixForAttributes = joclAttrPrefix;
    }

    public Class getType(int i) {
        return (Class)this._typeList.get(i);
    }

    public Object getValue(int i) {
        return this._valueList.get(i);
    }

    public void startElement(String uri, String localName, String qname, Attributes attr) throws SAXException {
        try {
            if (this.isJoclNamespace(uri, localName, qname)) {
                if ("object".equals(localName)) {
                    String cname = this.getAttributeValue("class", attr);
                    String isnullstr = this.getAttributeValue("null", attr, "false");
                    boolean isnull = "true".equalsIgnoreCase(isnullstr) || "yes".equalsIgnoreCase(isnullstr);
                    this._cur = new ConstructorDetails(cname, this._cur, isnull);
                } else if ("boolean".equals(localName)) {
                    String valstr = this.getAttributeValue("value", attr, "false");
                    boolean val = "true".equalsIgnoreCase(valstr) || "yes".equalsIgnoreCase(valstr);
                    this.addObject(Boolean.TYPE, new Boolean(val));
                } else if ("byte".equals(localName)) {
                    byte val = Byte.parseByte(this.getAttributeValue("value", attr, "0"));
                    this.addObject(Byte.TYPE, new Byte(val));
                } else if ("char".equals(localName)) {
                    char val = '\u0000';
                    String valstr = this.getAttributeValue("value", attr);
                    if (null == valstr) {
                        val = '\u0000';
                    } else {
                        if (valstr.length() > 1) {
                            throw new SAXException("if present, char value must be exactly one character long");
                        }
                        if (valstr.length() == 1) {
                            val = valstr.charAt(0);
                        } else if (valstr.length() == 0) {
                            throw new SAXException("if present, char value must be exactly one character long");
                        }
                    }
                    this.addObject(Character.TYPE, new Character(val));
                } else if ("double".equals(localName)) {
                    double val = Double.parseDouble(this.getAttributeValue("value", attr, "0"));
                    this.addObject(Double.TYPE, new Double(val));
                } else if ("float".equals(localName)) {
                    float val = Float.parseFloat(this.getAttributeValue("value", attr, "0"));
                    this.addObject(Float.TYPE, new Float(val));
                } else if ("int".equals(localName)) {
                    int val = Integer.parseInt(this.getAttributeValue("value", attr, "0"));
                    this.addObject(Integer.TYPE, new Integer(val));
                } else if ("long".equals(localName)) {
                    long val = Long.parseLong(this.getAttributeValue("value", attr, "0"));
                    this.addObject(Long.TYPE, new Long(val));
                } else if ("short".equals(localName)) {
                    short val = Short.parseShort(this.getAttributeValue("value", attr, "0"));
                    this.addObject(Short.TYPE, new Short(val));
                } else if ("string".equals(localName)) {
                    String val = this.getAttributeValue("value", attr);
                    this.addObject("".getClass(), val);
                }
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        try {
            if (this.isJoclNamespace(uri, localName, qname) && "object".equals(localName)) {
                ConstructorDetails temp = this._cur;
                this._cur = this._cur.getParent();
                if (null == this._cur) {
                    this._typeList.add(temp.getType());
                    this._valueList.add(temp.createObject());
                } else {
                    this._cur.addArgument(temp.getType(), temp.createObject());
                }
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    protected boolean isJoclNamespace(String uri, String localname, String qname) {
        if ("http://apache.org/xml/xmlns/jakarta/commons/jocl".equals(uri)) {
            return true;
        }
        if (this._acceptEmptyNamespaceForElements && (null == uri || "".equals(uri))) {
            return true;
        }
        return this._acceptJoclPrefixForElements && (null == uri || "".equals(uri)) && qname.startsWith("jocl:");
    }

    protected String getAttributeValue(String localname, Attributes attr) {
        return this.getAttributeValue(localname, attr, null);
    }

    protected String getAttributeValue(String localname, Attributes attr, String implied) {
        String val = attr.getValue("http://apache.org/xml/xmlns/jakarta/commons/jocl", localname);
        if (null == val && this._acceptEmptyNamespaceForAttributes) {
            val = attr.getValue("", localname);
        }
        if (null == val && this._acceptJoclPrefixForAttributes) {
            val = attr.getValue("", "jocl:" + localname);
        }
        return null == val ? implied : val;
    }

    protected void addObject(Class type, Object val) {
        if (null == this._cur) {
            this._typeList.add(type);
            this._valueList.add(val);
        } else {
            this._cur.addArgument(type, val);
        }
    }

    class ConstructorDetails {
        private ConstructorDetails _parent = null;
        private Class _type = null;
        private ArrayList _argTypes = null;
        private ArrayList _argValues = null;
        private boolean _isnull = false;

        public ConstructorDetails(String classname, ConstructorDetails parent, boolean isnull) throws ClassNotFoundException {
            this(Class.forName(classname), parent, isnull);
        }

        public ConstructorDetails(Class type, ConstructorDetails parent, boolean isnull) {
            this._parent = parent;
            this._type = type;
            this._argTypes = new ArrayList();
            this._argValues = new ArrayList();
            this._isnull = isnull;
        }

        public void addArgument(Class type, Object val) {
            if (this._isnull) {
                throw new NullPointerException("can't add arguments to null instances");
            }
            this._argTypes.add(type);
            this._argValues.add(val);
        }

        public Class getType() {
            return this._type;
        }

        public ConstructorDetails getParent() {
            return this._parent;
        }

        public Object createObject() throws InstantiationException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
            if (this._isnull) {
                return null;
            }
            Class k = this.getType();
            Class[] argtypes = this._argTypes.toArray(new Class[0]);
            Object[] argvals = this._argValues.toArray();
            return ConstructorUtil.invokeConstructor(k, argtypes, argvals);
        }
    }
}

