/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.sync;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;

public class HashWriter {
    public static int blockSize = 1024;

    public static byte[] getHash(File f) throws Exception {
        MessageDigest hashSum = MessageDigest.getInstance("SHA-256");
        BufferedInputStream fb = new BufferedInputStream(new FileInputStream(f));
        byte[] buffer = new byte[blockSize];
        int readSize = fb.read(buffer);
        while (readSize > 0) {
            hashSum.update(buffer, 0, readSize);
            readSize = fb.read(buffer);
        }
        fb.close();
        byte[] fileHash = new byte[hashSum.getDigestLength()];
        fileHash = hashSum.digest();
        return fileHash;
    }

    public static boolean compareHash(byte[] h1, byte[] h2) {
        int length = h1.length;
        if (length != h2.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (h1[i] != h2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

