/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JPanel;
import org.openconcerto.ui.preferences.PrefView;
import org.openconcerto.ui.preferences.PreferencePanel;
import org.openconcerto.utils.AutoLayouter;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.checks.ValidChangeSupport;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;

public abstract class JavaPrefPreferencePanel
extends JPanel
implements PreferencePanel {
    private final String title;
    private Preferences prefs;
    private final AutoLayouter layouter;
    private final Set<PrefView<?>> views;
    private boolean modified;
    private final ValidChangeSupport validSupp;

    public JavaPrefPreferencePanel(String title, Preferences prefs) {
        super(new BorderLayout());
        this.title = title;
        this.prefs = prefs;
        this.views = new HashSet();
        this.modified = false;
        this.validSupp = new ValidChangeSupport(this);
        JPanel content = new JPanel();
        this.add((Component)content, "First");
        this.layouter = new AutoLayouter(content);
    }

    public final void setPrefs(Preferences prefs) {
        if (this.prefs != null) {
            throw new IllegalStateException("Already set : " + this.prefs);
        }
        this.prefs = prefs;
    }

    @Override
    public ValidState getValidState() {
        boolean res = true;
        ArrayList<String> pbs = new ArrayList<String>();
        for (PrefView<?> v : this.views) {
            ValidState validState = v.getVW().getValidState();
            if (validState.isValid()) continue;
            String explanation = "'" + v.getName() + "' n'est pas valide";
            String txt = validState.getValidationText();
            if (txt != null) {
                explanation = String.valueOf(explanation) + " (" + txt + ")";
            }
            pbs.add(explanation);
            res = false;
        }
        return ValidState.create(res, CollectionUtils.join(pbs, "\n"));
    }

    @Override
    public final void addValidListener(ValidListener l) {
        this.validSupp.addValidListener(l);
    }
}

