/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.preferences;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JOptionPane;

public abstract class AbstractProps {
    protected final Properties props = new Properties();

    protected AbstractProps() {
        this.load();
    }

    protected abstract String getPropsFileName();

    public String getPropertySuffix() {
        return "";
    }

    public String getStringProperty(String name) {
        String property = this.getProperty(name);
        if (property == null) {
            return this.getDefaultStringValue();
        }
        return property;
    }

    public final String getProperty(String name) {
        String key = String.valueOf(name) + this.getPropertySuffix();
        String property = this.props.getProperty(key);
        return property;
    }

    public final Boolean getBooleanValue(String name) {
        String property = this.getProperty(name);
        if (property == null) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(property);
    }

    public final boolean getBooleanValue(String name, boolean defaultValue) {
        String property = this.getProperty(name);
        if (property == null) {
            return defaultValue;
        }
        return Boolean.valueOf(property);
    }

    public String getDefaultStringValue() {
        return "";
    }

    public final int getIntProperty(String name) {
        return this.getIntProperty(name, this.getDefautIntValue());
    }

    public final int getIntProperty(String name, int defaultVal) {
        String property = this.getProperty(name);
        return property == null ? defaultVal : Integer.valueOf(property);
    }

    protected int getDefautIntValue() {
        return -1;
    }

    public void load() {
        block13: {
            File file = new File(this.getPropsFileName());
            System.out.println("Loading properties from " + file.getAbsolutePath());
            if (!file.exists()) {
                System.out.println("Warning: " + file.getAbsolutePath() + " does not exist");
                return;
            }
            BufferedInputStream bufferedInputStream = null;
            try {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    bufferedInputStream = new BufferedInputStream(fileInputStream);
                    this.props.load(bufferedInputStream);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "Impossible de lire le fichier de configuration:\n" + file.getAbsolutePath());
                    e.printStackTrace();
                    if (bufferedInputStream == null) break block13;
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

