/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import org.openconcerto.ui.JMultiLineToolTip;

class MultiLineToolTipUI
extends BasicToolTipUI {
    static MultiLineToolTipUI sharedInstance = new MultiLineToolTipUI();
    protected CellRendererPane rendererPane;
    private JTextArea textArea;

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.rendererPane = new CellRendererPane();
        c.add(this.rendererPane);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.remove(this.rendererPane);
        this.rendererPane = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension size = c.getSize();
        this.textArea.setOpaque(false);
        this.textArea.setBackground(c.getBackground());
        this.rendererPane.paintComponent(g, this.textArea, c, 1, 1, size.width - 1, size.height - 1, true);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            return new Dimension(0, 0);
        }
        this.textArea = new JTextArea(tipText);
        this.textArea.setFont(new JTextField().getFont());
        this.rendererPane.removeAll();
        this.rendererPane.add(this.textArea);
        this.textArea.setWrapStyleWord(true);
        int width = ((JMultiLineToolTip)c).getFixedWidth();
        int columns = ((JMultiLineToolTip)c).getColumns();
        if (columns > 0) {
            this.textArea.setColumns(columns);
            this.textArea.setSize(0, 0);
            this.textArea.setLineWrap(true);
            this.textArea.setSize(this.textArea.getPreferredSize());
        } else if (width > 0) {
            this.textArea.setLineWrap(true);
            Dimension d = this.textArea.getPreferredSize();
            d.width = width;
            ++d.height;
            this.textArea.setSize(d);
        } else {
            this.textArea.setLineWrap(false);
        }
        Dimension dim = this.textArea.getPreferredSize();
        ++dim.height;
        ++dim.width;
        return dim;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }
}

