/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list.search;

import java.util.Collection;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.search.SearchQueue;
import org.openconcerto.sql.view.list.search.SearchRunnable;

public final class SearchOne
extends SearchRunnable {
    final ListSQLLine modifiedLine;
    final Collection<Integer> modifiedIndex;
    final int id;
    private Mode mode;

    public SearchOne(SearchQueue q, int id, ListSQLLine modifiedLine, Collection<Integer> modifiedIndex) {
        super(q);
        this.id = id;
        this.modifiedLine = modifiedLine;
        this.modifiedIndex = modifiedIndex;
        this.mode = null;
    }

    public synchronized void setMode(Mode m) {
        if (this.mode != null) {
            throw new IllegalStateException("mode not null");
        }
        this.mode = m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SearchOne searchOne = this;
        synchronized (searchOne) {
            if (this.mode == null) {
                throw new IllegalStateException("null mode");
            }
        }
        if (this.mode == Mode.ADD) {
            if (this.matchFilter(this.modifiedLine)) {
                this.add();
            }
        } else if (this.mode == Mode.REMOVE) {
            this.remove();
        } else if (this.mode == Mode.CHANGE) {
            if (this.matchFilter(this.modifiedLine)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchOne.this.getAccess().fullListChanged(SearchOne.this.modifiedLine, SearchOne.this.modifiedIndex);
                    }
                });
            } else {
                this.remove();
            }
        }
    }

    private void add() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchOne.this.getAccess().addToList(SearchOne.this.modifiedLine);
            }
        });
    }

    private void remove() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchOne.this.getAccess().removeFromList(SearchOne.this.id);
            }
        });
    }

    public static enum Mode {
        ADD,
        REMOVE,
        CHANGE,
        NO_CHANGE;

    }
}

