/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list.search;

import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.search.ChangeListRunnable;
import org.openconcerto.sql.view.list.search.SearchOne;
import org.openconcerto.sql.view.list.search.SearchQueue;

final class ChangeListOne
extends ChangeListRunnable {
    private final ListSQLLine line;
    private final SearchOne search;
    private final int id;

    ChangeListOne(String name, SearchQueue q, ListSQLLine line, int id, SearchOne runnable) {
        super(name, q);
        this.line = line;
        this.id = id;
        this.search = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<ListSQLLine> list = this.getFullList();
        synchronized (list) {
            int modifiedIndex = this.fullIndexFromID(this.id);
            if (modifiedIndex < 0) {
                if (this.line != null) {
                    this.getFullList().add(this.line);
                    Collections.sort(this.getFullList());
                    this.search.setMode(SearchOne.Mode.ADD);
                } else {
                    this.search.setMode(SearchOne.Mode.NO_CHANGE);
                }
            } else if (this.line != null) {
                this.getFullList().set(modifiedIndex, this.line);
                Collections.sort(this.getFullList());
                this.search.setMode(SearchOne.Mode.CHANGE);
            } else {
                this.getFullList().remove(modifiedIndex);
                this.search.setMode(SearchOne.Mode.REMOVE);
            }
        }
    }
}

