/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.ITextWithCompletion;
import org.openconcerto.sql.sqlobject.SelectionListener;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.SQLTextComboTableCellEditor;
import org.openconcerto.sql.view.list.TextTableCellEditorWithCompletion;
import org.openconcerto.sql.view.list.ValidStateChecker;
import org.openconcerto.ui.TextAreaRenderer;

public class AutoCompletionManager
implements SelectionListener {
    private SQLTableElement fromTableElement;
    private RowValuesTable table;
    private TextTableCellEditorWithCompletion editor;
    private int lastSelectedComboId = 1;
    protected boolean foreign;
    private SQLField fillFrom;
    private RowValuesTableModel tableModel;
    ITextWithCompletion t;
    SQLTextComboTableCellEditor textComboCellEdit;
    private HashMap<String, String> fillBy = new HashMap();
    private int lastId = -1;
    private int lastEditingRow = -1;

    public AutoCompletionManager(SQLTableElement fromTableElement, SQLField fillFrom, RowValuesTable table, RowValuesTableModel tableModel) {
        this(fromTableElement, fillFrom, table, tableModel, 2, false);
    }

    public AutoCompletionManager(SQLTableElement fromTableElement, SQLField fillFrom, RowValuesTable table, RowValuesTableModel tableModel, int modeCompletion, boolean expandWithShowAs, boolean foreign, ValidStateChecker checker) {
        this.foreign = foreign;
        Vector<String> l = new Vector<String>();
        if (expandWithShowAs) {
            List<SQLField> lSQLFields = Configuration.getInstance().getShowAs().getFieldExpand(fillFrom.getTable());
            int i = 0;
            while (i < lSQLFields.size()) {
                l.add(lSQLFields.get(i).getName());
                ++i;
            }
        } else {
            l.add(fillFrom.getName());
        }
        ComboSQLRequest req = new ComboSQLRequest(fillFrom.getTable(), l);
        this.init(fromTableElement, fillFrom, table, tableModel, modeCompletion, req, foreign, checker);
    }

    public AutoCompletionManager(SQLTableElement fromTableElement, SQLField fillFrom, RowValuesTable table, RowValuesTableModel tableModel, int modeCompletion, boolean expandWithShowAs) {
        this(fromTableElement, fillFrom, table, tableModel, modeCompletion, expandWithShowAs, false, new ValidStateChecker());
    }

    public void init(SQLTableElement fromTableElement, SQLField fillFrom, RowValuesTable table, RowValuesTableModel tableModel, int modeCompletion, ComboSQLRequest req, boolean foreign, ValidStateChecker validStateChecker) {
        this.tableModel = tableModel;
        this.fromTableElement = fromTableElement;
        this.fillFrom = fillFrom;
        this.table = table;
        if (foreign) {
            TableCellEditor cellEdit = this.fromTableElement.getTableCellEditor(null);
            if (cellEdit instanceof SQLTextComboTableCellEditor) {
                this.textComboCellEdit = (SQLTextComboTableCellEditor)cellEdit;
                this.textComboCellEdit.addSelectionListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        int i = AutoCompletionManager.this.textComboCellEdit.getComboSelectedId();
                        if (AutoCompletionManager.this.lastSelectedComboId != i) {
                            AutoCompletionManager.this.idSelected(i, null);
                        }
                        AutoCompletionManager.this.lastSelectedComboId = i;
                        System.err.println("editing stopped");
                    }
                });
                this.textComboCellEdit.addCellEditorListener(new CellEditorListener(){

                    @Override
                    public void editingCanceled(ChangeEvent e) {
                        AutoCompletionManager.this.lastSelectedComboId = AutoCompletionManager.this.textComboCellEdit.getComboSelectedId();
                    }

                    @Override
                    public void editingStopped(ChangeEvent e) {
                        AutoCompletionManager.this.lastSelectedComboId = AutoCompletionManager.this.textComboCellEdit.getComboSelectedId();
                    }
                });
            }
        } else {
            this.t = new ITextWithCompletion(req, true);
            this.t.setModeCompletion(modeCompletion);
            this.editor = new TextTableCellEditorWithCompletion(table, this.t, validStateChecker);
            if (this.fillFrom.getType().getType() == 12) {
                this.t.setLimitedSize(this.fillFrom.getType().getSize());
                this.editor.setLimitedSize(this.fillFrom.getType().getSize());
            }
            this.fromTableElement.setEditor(this.editor);
            this.fromTableElement.setRenderer(new TextAreaRenderer());
            this.t.addSelectionListener(this);
        }
    }

    public void fill(String string, String string2) {
        this.fillBy.put(string, string2);
    }

    @Override
    public void idSelected(final int id, Object source) {
        final int rowE = this.table.getEditingRow();
        if (rowE < 0) {
            this.lastEditingRow = rowE;
            return;
        }
        if (this.lastEditingRow == rowE && this.lastId == id) {
            return;
        }
        this.lastId = id;
        this.lastEditingRow = rowE;
        if (id > 1) {
            if (this.table.getCellEditor() != null && !this.foreign) {
                this.table.getCellEditor().stopCellEditing();
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    final SQLRow rowV = AutoCompletionManager.this.fillFrom.getTable().getRow(id);
                    final Set keys = AutoCompletionManager.this.fillBy.keySet();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (String from : keys) {
                                String to = (String)AutoCompletionManager.this.fillBy.get(from);
                                Object fromV = AutoCompletionManager.this.getValueFrom(rowV, from);
                                int column = AutoCompletionManager.this.tableModel.getColumnForField(to);
                                if (column >= 0) {
                                    if (AutoCompletionManager.this.table.getRowValuesTableModel().getValueAt(rowE, column).equals(fromV)) continue;
                                    AutoCompletionManager.this.table.getRowValuesTableModel().setValueAt(fromV, rowE, column);
                                    if (AutoCompletionManager.this.table.getEditingColumn() != column || AutoCompletionManager.this.table.getEditingRow() != rowE) continue;
                                    AutoCompletionManager.this.table.editingCanceled(null);
                                    AutoCompletionManager.this.table.setColumnSelectionInterval(column, column);
                                    AutoCompletionManager.this.table.setRowSelectionInterval(rowE, rowE);
                                    if (!AutoCompletionManager.this.table.editCellAt(rowE, column) || AutoCompletionManager.this.table.getEditorComponent() == null) continue;
                                    AutoCompletionManager.this.table.getEditorComponent().requestFocusInWindow();
                                    continue;
                                }
                                AutoCompletionManager.this.table.getRowValuesTableModel().putValue(fromV, rowE, to);
                            }
                            AutoCompletionManager.this.table.resizeAndRepaint();
                        }
                    });
                }
            }).start();
        }
    }

    protected Object getValueFrom(SQLRow row, String field) {
        return row.getObject(field);
    }

    public void setWhere(Where w) {
        if (this.t != null) {
            this.t.setWhere(w);
        } else {
            this.textComboCellEdit.setWhere(w);
        }
    }

    public void setFillWithField(String s) {
        this.t.setFillWithField(s);
    }
}

