/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.openconcerto.sql.Log;

public abstract class AbstractFileTransfertHandler
extends TransferHandler {
    private static DataFlavor URIListFlavor = null;

    public static synchronized DataFlavor getURIListFlavor() {
        if (URIListFlavor == null) {
            try {
                URIListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return URIListFlavor;
    }

    public abstract void handleFile(File var1);

    @Override
    public boolean importData(JComponent c, Transferable t) {
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        final ArrayList<File> list = new ArrayList<File>();
        try {
            if (this.hasFileFlavor(t.getTransferDataFlavors())) {
                list.addAll((List)t.getTransferData(DataFlavor.javaFileListFlavor));
            } else if (this.hasURIListFlavor(t.getTransferDataFlavors())) {
                list.addAll(AbstractFileTransfertHandler.textURIListToFileList((String)t.getTransferData(AbstractFileTransfertHandler.getURIListFlavor())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Thread thread = new Thread("AbstractFileTransfertHandler"){

                @Override
                public void run() {
                    for (File realFile : list) {
                        AbstractFileTransfertHandler.this.handleFile(realFile);
                    }
                }
            };
            thread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list.size() > 0;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        if (this.hasFileFlavor(flavors) || this.hasURIListFlavor(flavors)) {
            return true;
        }
        Log.get().config("No files or URL found in dropped object");
        return false;
    }

    private boolean hasFileFlavor(DataFlavor[] flavors) {
        int i = 0;
        while (i < flavors.length) {
            if (DataFlavor.javaFileListFlavor.equals(flavors[i]) || "application/x-java-remote-object".equals(flavors[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasURIListFlavor(DataFlavor[] flavors) {
        int i = 0;
        while (i < flavors.length) {
            if (AbstractFileTransfertHandler.getURIListFlavor().equals(flavors[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static List<File> textURIListToFileList(String data) {
        ArrayList<File> list = new ArrayList<File>(1);
        StringTokenizer st = new StringTokenizer(data, "\r\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                URI uri = new URI(s);
                File file = new File(uri);
                list.add(file);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

