/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.ShowAs;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.FilteredFillSQLRequest;
import org.openconcerto.utils.cc.ITransformer;

public class ListSQLRequest
extends FilteredFillSQLRequest {
    private final List<SQLField> listFields;

    public ListSQLRequest(SQLTable table, List fieldss) {
        this(table, fieldss, null);
    }

    public ListSQLRequest(SQLTable table, List fieldss, Where where) {
        this(table, fieldss, where, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ListSQLRequest(SQLTable table, List fieldss, Where where, final SQLTable cutAtAncestor) {
        super(table, where);
        if (!this.getPrimaryTable().isOrdered()) {
            throw new IllegalArgumentException(table + " is not ordered.");
        }
        if (cutAtAncestor == table) {
            throw new IllegalArgumentException("the primaryTable: " + this.getPrimaryTable() + "is the same than cutAtAncestor");
        }
        this.listFields = new ArrayList<SQLField>();
        for (Object field : fieldss) {
            SQLField f;
            if (field instanceof String) {
                f = this.getPrimaryTable().getField((String)field);
            } else {
                if (!(field instanceof SQLField)) throw new IllegalArgumentException("must be a fieldname or a SQLField but got : " + field);
                SQLField fToCheck = (SQLField)field;
                if (!fToCheck.getTable().equals(this.getPrimaryTable())) throw new IllegalArgumentException("field " + fToCheck + " not part of the primary table : " + this.getPrimaryTable());
                f = fToCheck;
            }
            this.listFields.add(f);
        }
        if (cutAtAncestor == null) return;
        this.getGraph().walkGraph(null, new ITransformer<SQLRowValuesCluster.State<Object>, Object>(){

            @Override
            public Object transformChecked(SQLRowValuesCluster.State<Object> input) {
                SQLRowValues current = input.getCurrent();
                for (String field : new HashSet<String>(current.getFields())) {
                    Object value = current.getObject(field);
                    if (!(value instanceof SQLRowValues) || ((SQLRowValues)value).getTable() != cutAtAncestor) continue;
                    current.remove(field);
                }
                return null;
            }
        });
    }

    @Override
    protected ShowAs getShowAs() {
        return Configuration.getInstance().getShowAs();
    }

    public final List<SQLField> getFields() {
        return Collections.unmodifiableList(this.listFields);
    }

    @Override
    protected void customizeToFetch(SQLRowValues graphToFetch) {
        super.customizeToFetch(graphToFetch);
        this.addField(graphToFetch, this.getPrimaryTable().getCreationDateField());
        this.addField(graphToFetch, this.getPrimaryTable().getCreationUserField());
        this.addField(graphToFetch, this.getPrimaryTable().getModifDateField());
        this.addField(graphToFetch, this.getPrimaryTable().getModifUserField());
    }

    private void addField(SQLRowValues graphToFetch, SQLField f) {
        if (f != null) {
            if (f.isKey()) {
                graphToFetch.put(f.getName(), new SQLRowValues(f.getTable().getForeignTable(f.getName())).put("NOM", null).put("PRENOM", null));
            } else {
                graphToFetch.put(f.getName(), null);
            }
        }
    }
}

