/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.utils.CollectionUtils;

public class Step {
    private final SQLTable from;
    private final SQLTable to;
    private final Map<SQLField, Boolean> fields;
    private final SQLField singleField;

    public static final Step create(SQLTable start, SQLField fField, Boolean direction) throws IllegalArgumentException {
        Boolean nonNullDir;
        Link l = fField.getDBSystemRoot().getGraph().getForeignLink(fField);
        if (l == null) {
            throw new IllegalArgumentException(fField + " is not a foreign field.");
        }
        SQLTable end = l.oppositeVertex(start);
        SQLTable fieldStart = fField.getTable();
        Boolean computedDirection = start == end ? null : Boolean.valueOf(fieldStart == start);
        if (computedDirection == null && direction == null) {
            throw new IllegalArgumentException("the field references its table: " + fField + ", you must specify the direction");
        }
        if (direction != null && computedDirection != null && direction != computedDirection) {
            throw new IllegalArgumentException("wrong direction: " + direction + ", real is : " + computedDirection);
        }
        Boolean bl = nonNullDir = direction == null ? computedDirection : direction;
        assert (nonNullDir != null);
        return new Step(start, fField, nonNullDir, end);
    }

    private Step(SQLTable start, Map<SQLField, Boolean> fields, SQLField singleField, SQLTable end) {
        assert (start != null && end != null);
        assert (fields.size() > 0);
        assert (CollectionUtils.getSole(fields.keySet()) == singleField);
        assert (!new HashSet<Boolean>(fields.values()).contains(null)) : "some directions are unknown : " + fields;
        assert (fields instanceof AbstractMap) : "Fields might not be thread-safe";
        this.from = start;
        this.to = end;
        this.fields = Collections.unmodifiableMap(fields);
        this.singleField = singleField;
    }

    private Step(SQLTable start, Map<SQLField, Boolean> fields, SQLTable end) {
        this(start, new HashMap<SQLField, Boolean>(fields), CollectionUtils.getSole(fields.keySet()), end);
    }

    private Step(SQLTable start, SQLField field, boolean foreign, SQLTable end) {
        this(start, Collections.singletonMap(field, foreign), field, end);
    }

    public final Step reverse() {
        HashMap<SQLField, Boolean> reverseFields = new HashMap<SQLField, Boolean>(this.fields.size());
        for (Map.Entry<SQLField, Boolean> e : this.fields.entrySet()) {
            reverseFields.put(e.getKey(), e.getValue() == false);
        }
        return new Step(this.to, reverseFields, this.from);
    }

    public final SQLTable getFrom() {
        return this.from;
    }

    public final SQLTable getTo() {
        return this.to;
    }

    public final Set<SQLField> getFields() {
        return this.fields.keySet();
    }

    public final SQLField getSingleField() {
        return this.singleField;
    }

    public final boolean isForeign(SQLField f) {
        return this.fields.get(f);
    }

    public final Boolean isForeign() {
        return CollectionUtils.getSole(new HashSet<Boolean>(this.fields.values()));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " from: " + this.getFrom() + " to: " + this.getTo() + "\n" + this.fields;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Step) {
            Step o = (Step)obj;
            return this.from.equals(o.from) && this.fields.equals(o.fields);
        }
        return false;
    }

    public int hashCode() {
        return this.fields.hashCode();
    }
}

