/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import org.jgrapht.Graph;

public class DirectedEdge<V> {
    private final V src;
    private final V dst;

    public DirectedEdge(V src, V dst) {
        this.src = src;
        this.dst = dst;
    }

    public final V getSource() {
        return this.src;
    }

    public final V getTarget() {
        return this.dst;
    }

    public final V oppositeVertex(V end) {
        if (end == this.getSource()) {
            return this.getTarget();
        }
        if (end == this.getTarget()) {
            return this.getSource();
        }
        throw new IllegalArgumentException(end + " is not an end of " + this);
    }

    public String toString() {
        return "<" + this.getSource() + " -> " + this.getTarget() + ">";
    }

    public boolean equals(Object other) {
        if (!(other instanceof DirectedEdge)) {
            return false;
        }
        DirectedEdge o = (DirectedEdge)other;
        return this.getSource().equals(o.getSource()) && this.getTarget().equals(o.getTarget());
    }

    public int hashCode() {
        return this.getSource().hashCode() + this.getTarget().hashCode();
    }

    public static final <V, E extends DirectedEdge<V>> void addEdge(Graph<V, E> g, E e) {
        g.addEdge(e.getSource(), e.getTarget(), e);
    }
}

