/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.utils.cc.IClosure;

public class MySQLBase
extends SQLBase {
    private List<String> modes = null;
    private static final Pattern backslashQuote = Pattern.compile("\\\\");

    MySQLBase(SQLServer server, String name, String login, String pass, IClosure<SQLDataSource> dsInit) {
        super(server, name, login, pass, dsInit);
    }

    public final synchronized List<String> getModes() {
        if (this.modes == null) {
            String modes = (String)this.getDataSource().executeScalar("SELECT @@global.sql_mode;");
            this.modes = Arrays.asList(modes.split(","));
        }
        return this.modes;
    }

    private final boolean shouldEscape() {
        return !this.getModes().contains("NO_BACKSLASH_ESCAPES");
    }

    @Override
    public final String quoteString(String s) {
        String res = super.quoteString(s);
        return this.shouldEscape() ? backslashQuote.matcher(res).replaceAll("\\\\\\\\") : res;
    }
}

