/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.core.humanresources.payroll.component.VariableRowTreeNode;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableListener;

public class RubriquePayeTree
extends JTree {
    private static final SQLTable tableBrut = Configuration.getInstance().getBase().getTable("RUBRIQUE_BRUT");
    private static final SQLTable tableCotis = Configuration.getInstance().getBase().getTable("RUBRIQUE_COTISATION");
    private static final SQLTable tableCaisseCotis = Configuration.getInstance().getBase().getTable("CAISSE_COTISATION");
    private static final SQLTable tableNet = Configuration.getInstance().getBase().getTable("RUBRIQUE_NET");
    private static final SQLTable tableComm = Configuration.getInstance().getBase().getTable("RUBRIQUE_COMM");
    private static DefaultMutableTreeNode nodeBrut;
    private static DefaultMutableTreeNode nodeCotisation;
    private static DefaultMutableTreeNode nodeNet;
    private static DefaultMutableTreeNode nodeComm;
    private static final DefaultMutableTreeNode rootVar;
    private static final DefaultTreeModel model;
    private static final Map mapNodeCotisation;
    private static int test;

    static {
        rootVar = new DefaultMutableTreeNode("Rubriques");
        model = new DefaultTreeModel(rootVar, false);
        mapNodeCotisation = new HashMap();
        test = 0;
        RubriquePayeTree.loadAllRubrique();
        RubriquePayeTree.setSQLTableListener();
    }

    public RubriquePayeTree() {
        this.setModel(model);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        this.setCellRenderer(renderer);
    }

    private static void loadAllRubrique() {
        RubriquePayeTree.loadNodeBrut();
        rootVar.add(nodeBrut);
        RubriquePayeTree.loadNodeCot();
        rootVar.add(nodeCotisation);
        RubriquePayeTree.loadNodeNet();
        rootVar.add(nodeNet);
        RubriquePayeTree.loadNodeComm();
        rootVar.add(nodeComm);
    }

    private static void loadNodeComm() {
        nodeComm = new DefaultMutableTreeNode("Commentaires");
        SQLSelect selAllCodeCommName = new SQLSelect(Configuration.getInstance().getBase());
        selAllCodeCommName.addSelect(tableComm.getField("ID"));
        selAllCodeCommName.addRawOrder("\"RUBRIQUE_COMM\".\"CODE\"");
        String reqAllCodeCommName = selAllCodeCommName.asString();
        System.err.println("REquest load node brut :: " + reqAllCodeCommName);
        Object[] objCodeCommID = ((List)Configuration.getInstance().getBase().getDataSource().execute(reqAllCodeCommName, new ArrayListHandler())).toArray();
        int i = 0;
        while (i < objCodeCommID.length) {
            SQLRow rowTmp = tableComm.getRow(Integer.parseInt(((Object[])objCodeCommID[i])[0].toString()));
            VariableRowTreeNode nodeVar = new VariableRowTreeNode(rowTmp);
            RubriquePayeTree.addNode(nodeVar, nodeComm);
            ++i;
        }
    }

    private static void loadNodeNet() {
        nodeNet = new DefaultMutableTreeNode("Net");
        SQLSelect selAllCodeNetName = new SQLSelect(Configuration.getInstance().getBase());
        selAllCodeNetName.addSelect(tableNet.getField("ID"));
        selAllCodeNetName.addRawOrder("\"RUBRIQUE_NET\".\"CODE\"");
        String reqAllCodeNetName = selAllCodeNetName.asString();
        System.err.println("REquest load node brut :: " + reqAllCodeNetName);
        Object[] objCodeNetID = ((List)Configuration.getInstance().getBase().getDataSource().execute(reqAllCodeNetName, new ArrayListHandler())).toArray();
        int i = 0;
        while (i < objCodeNetID.length) {
            SQLRow rowTmp = tableNet.getRow(Integer.parseInt(((Object[])objCodeNetID[i])[0].toString()));
            VariableRowTreeNode nodeVar = new VariableRowTreeNode(rowTmp);
            RubriquePayeTree.addNode(nodeVar, nodeNet);
            ++i;
        }
    }

    private static void loadNodeCot() {
        nodeCotisation = new DefaultMutableTreeNode("Cotisation");
        SQLSelect selAllCodeCotisName = new SQLSelect(Configuration.getInstance().getBase());
        selAllCodeCotisName.addSelect(tableCotis.getField("ID"));
        selAllCodeCotisName.addRawOrder("\"RUBRIQUE_COTISATION\".\"CODE\"");
        String reqAllCodeCotisName = selAllCodeCotisName.asString();
        System.err.println("REquest load node brut :: " + reqAllCodeCotisName);
        Object[] objCodeCotisID = ((List)Configuration.getInstance().getBase().getDataSource().execute(reqAllCodeCotisName, new ArrayListHandler())).toArray();
        int i = 0;
        while (i < objCodeCotisID.length) {
            SQLRow rowTmp = tableCotis.getRow(Integer.parseInt(((Object[])objCodeCotisID[i])[0].toString()));
            if (mapNodeCotisation.get(rowTmp.getObject("ID_CAISSE_COTISATION")) == null) {
                SQLRow rowCaisseCotis = tableCaisseCotis.getRow(rowTmp.getInt("ID_CAISSE_COTISATION"));
                DefaultMutableTreeNode nodeCot = new DefaultMutableTreeNode(rowCaisseCotis.getString("NOM"));
                mapNodeCotisation.put(rowTmp.getObject("ID_CAISSE_COTISATION"), nodeCot);
                nodeCotisation.add(nodeCot);
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)mapNodeCotisation.get(rowTmp.getObject("ID_CAISSE_COTISATION"));
            VariableRowTreeNode nodeVar = new VariableRowTreeNode(rowTmp);
            RubriquePayeTree.addNode(nodeVar, node);
            ++i;
        }
    }

    private static void loadNodeBrut() {
        nodeBrut = new DefaultMutableTreeNode("Brut");
        SQLSelect selAllCodeBrutName = new SQLSelect(Configuration.getInstance().getBase());
        selAllCodeBrutName.addSelect(tableBrut.getField("ID"));
        selAllCodeBrutName.addRawOrder("\"RUBRIQUE_BRUT\".\"CODE\"");
        String reqAllCodeBrutName = selAllCodeBrutName.asString();
        System.err.println("REquest load node brut :: " + reqAllCodeBrutName);
        Object[] objCodeBrutID = ((List)Configuration.getInstance().getBase().getDataSource().execute(reqAllCodeBrutName, new ArrayListHandler())).toArray();
        int i = 0;
        while (i < objCodeBrutID.length) {
            SQLRow rowTmp = tableBrut.getRow(Integer.parseInt(((Object[])objCodeBrutID[i])[0].toString()));
            VariableRowTreeNode nodeVar = new VariableRowTreeNode(rowTmp);
            RubriquePayeTree.addNode(nodeVar, nodeBrut);
            ++i;
        }
    }

    private static void addNode(VariableRowTreeNode nodeToAdd, MutableTreeNode nodeParent) {
        int n = 0;
        while (n < nodeParent.getChildCount()) {
            if (nodeToAdd.toString().compareToIgnoreCase(nodeParent.getChildAt(n).toString()) < 0) break;
            ++n;
        }
        model.insertNodeInto(nodeToAdd, nodeParent, n);
    }

    private static void modifyNode(SQLRow row, MutableTreeNode nodeParent) {
        int i = 0;
        while (i < nodeParent.getChildCount()) {
            VariableRowTreeNode v;
            TreeNode o = nodeParent.getChildAt(i);
            if (o instanceof VariableRowTreeNode && (v = (VariableRowTreeNode)o).getID() == row.getID()) {
                v.setRow(row);
                model.nodeChanged(v);
            }
            ++i;
        }
    }

    private static void removeNode(SQLRow row, MutableTreeNode nodeParent) {
        int i = 0;
        while (i < nodeParent.getChildCount()) {
            VariableRowTreeNode v;
            TreeNode o = nodeParent.getChildAt(i);
            if (o instanceof VariableRowTreeNode && (v = (VariableRowTreeNode)o).getID() == row.getID()) {
                model.removeNodeFromParent(v);
            }
            ++i;
        }
    }

    private static void setSQLTableListener() {
        System.err.println("Ajout listener " + test++);
        SQLTableListener listener = new SQLTableListener(){

            @Override
            public void rowModified(SQLTable table, int id) {
                System.err.println("row modified --> " + table.getName() + ", " + id);
                if (table.getName().equalsIgnoreCase(tableBrut.getName())) {
                    RubriquePayeTree.modifyNode(table.getRow(id), nodeBrut);
                } else if (table.getName().equalsIgnoreCase(tableCotis.getName())) {
                    RubriquePayeTree.modifyNode(table.getRow(id), nodeCotisation);
                } else if (table.getName().equalsIgnoreCase(tableNet.getName())) {
                    RubriquePayeTree.modifyNode(table.getRow(id), nodeNet);
                } else if (table.getName().equalsIgnoreCase(tableComm.getName())) {
                    RubriquePayeTree.modifyNode(table.getRow(id), nodeComm);
                }
            }

            @Override
            public void rowAdded(SQLTable table, int id) {
                System.err.println("row added --> " + table.getName() + ", " + id);
                VariableRowTreeNode nodeVar = new VariableRowTreeNode(table.getRow(id));
                if (table.getName().equalsIgnoreCase(tableBrut.getName())) {
                    RubriquePayeTree.addNode(nodeVar, nodeBrut);
                } else if (table.getName().equalsIgnoreCase(tableCotis.getName())) {
                    SQLRow rowTmp = table.getRow(id);
                    if (mapNodeCotisation.get(rowTmp.getObject("ID_CAISSE_COTISATION")) == null) {
                        SQLRow rowCaisseCotis = tableCaisseCotis.getRow(rowTmp.getInt("ID_CAISSE_COTISATION"));
                        DefaultMutableTreeNode nodeCot = new DefaultMutableTreeNode(rowCaisseCotis.getString("NOM"));
                        mapNodeCotisation.put(rowTmp.getObject("ID_CAISSE_COTISATION"), nodeCot);
                        nodeCotisation.add(nodeCot);
                    }
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)mapNodeCotisation.get(rowTmp.getObject("ID_CAISSE_COTISATION"));
                    RubriquePayeTree.addNode(nodeVar, node);
                } else if (table.getName().equalsIgnoreCase(tableNet.getName())) {
                    RubriquePayeTree.addNode(nodeVar, nodeNet);
                } else if (table.getName().equalsIgnoreCase(tableComm.getName())) {
                    RubriquePayeTree.addNode(nodeVar, nodeComm);
                }
            }

            @Override
            public void rowDeleted(SQLTable table, int id) {
                System.err.println("row deleted --> " + table.getName() + ", " + id);
                if (table.getName().equalsIgnoreCase(tableBrut.getName())) {
                    int i = 0;
                    while (i < nodeBrut.getChildCount()) {
                        RubriquePayeTree.removeNode(table.getRow(id), nodeBrut);
                        ++i;
                    }
                } else if (table.getName().equalsIgnoreCase(tableCotis.getName())) {
                    RubriquePayeTree.removeNode(table.getRow(id), nodeCotisation);
                } else if (table.getName().equalsIgnoreCase(tableNet.getName())) {
                    RubriquePayeTree.removeNode(table.getRow(id), nodeNet);
                } else if (table.getName().equalsIgnoreCase(tableComm.getName())) {
                    RubriquePayeTree.removeNode(table.getRow(id), nodeComm);
                }
            }
        };
        tableBrut.addTableListener(listener);
        tableComm.addTableListener(listener);
        tableCotis.addTableListener(listener);
        tableNet.addTableListener(listener);
    }
}

