/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.model;

import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.AbstractSheetXml;
import org.openconcerto.erp.panel.ListeFastPrintFrame;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.EmailComposer;
import org.openconcerto.utils.ExceptionHandler;

public class MouseSheetXmlListeListener {
    private Class<? extends AbstractSheetXml> clazz;
    private String fastPrintString = "Impression rapide";
    private String printString = "Impression ...";
    private String printAllString = "Imprimer les documents";
    private String previewString = "Voir le document";
    private String showString = "Modifier le document avec OpenOffice";
    private String generateString = "G\u00e9n\u00e9rer le document";
    private String mailPDFString = "Envoyer le document PDF par email";
    private String mailString = "Envoyer le document par email";
    private boolean previewIsVisible = true;
    private boolean showIsVisible = true;
    private boolean printIsVisible = true;
    private boolean generateIsVisible = true;
    private boolean previewHeader = false;
    private boolean showHeader = false;
    private boolean printHeader = false;
    private boolean generateHeader = false;

    public MouseSheetXmlListeListener(Class<? extends AbstractSheetXml> clazz) {
        this(clazz, true, true, true, true);
    }

    public MouseSheetXmlListeListener(Class<? extends AbstractSheetXml> clazz, boolean show, boolean preview, boolean print, boolean generate) {
        this.clazz = clazz;
        this.printIsVisible = print;
        this.previewIsVisible = preview;
        this.showIsVisible = show;
        this.generateIsVisible = generate;
    }

    protected Class<? extends AbstractSheetXml> getSheetClass() {
        return this.clazz;
    }

    protected AbstractSheetXml createAbstractSheet(SQLRow row) {
        try {
            Constructor<? extends AbstractSheetXml> ctor = this.getSheetClass().getConstructor(SQLRow.class);
            AbstractSheetXml sheet = ctor.newInstance(row);
            return sheet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getMailObject(SQLRow row) {
        return "";
    }

    public void setGenerateHeader(boolean generateHeader) {
        this.generateHeader = generateHeader;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    protected void sendMail(final AbstractSheetXml sheet, boolean readOnly) {
        final SQLRow row = sheet.getSQLRow();
        Set<SQLField> setContact = null;
        SQLTable tableContact = Configuration.getInstance().getRoot().findTable("CONTACT");
        setContact = row.getTable().getForeignKeys(tableContact);
        Set<SQLField> setClient = null;
        SQLTable tableClient = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("CLIENT");
        setClient = row.getTable().getForeignKeys(tableClient);
        String mail = "";
        for (SQLField field : setContact) {
            if (mail != null && mail.trim().length() != 0) continue;
            mail = row.getForeignRow(field.getName()).getString("EMAIL");
        }
        if (setClient != null && (mail == null || mail.trim().length() == 0)) {
            for (SQLField field : setClient) {
                SQLRow rowCli = row.getForeignRow(field.getName());
                if (mail != null && mail.trim().length() != 0) continue;
                mail = rowCli.getString("MAIL");
            }
        }
        if (mail == null || mail.trim().length() == 0) {
            SQLRow rowM;
            Set<SQLField> setM;
            SQLTable tableM;
            SQLBase base;
            SQLTable tableF = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("FOURNISSEUR");
            Set<SQLField> setF = null;
            setF = row.getTable().getForeignKeys(tableF);
            if (setF != null) {
                for (SQLField field : setF) {
                    SQLRow rowF = row.getForeignRow(field.getName());
                    if (mail != null && mail.trim().length() != 0) continue;
                    mail = rowF.getString("MAIL");
                }
            }
            if ((mail == null || mail.trim().length() == 0) && (base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete()).containsTable("MONTEUR")) {
                tableM = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("MONTEUR");
                setM = null;
                setM = row.getTable().getForeignKeys(tableM);
                if (setM != null) {
                    for (SQLField field : setM) {
                        rowM = row.getForeignRow(field.getName());
                        if (rowM.getForeignRow("ID_CONTACT_FOURNISSEUR") == null || rowM.getForeignRow("ID_CONTACT_FOURNISSEUR").isUndefined()) continue;
                        mail = rowM.getForeignRow("ID_CONTACT_FOURNISSEUR").getString("EMAIL");
                    }
                }
            }
            if ((mail == null || mail.trim().length() == 0) && (base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete()).containsTable("TRANSPORTEUR")) {
                tableM = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("TRANSPORTEUR");
                setM = null;
                setM = row.getTable().getForeignKeys(tableM);
                if (setM != null) {
                    for (SQLField field : setM) {
                        rowM = row.getForeignRow(field.getName());
                        if (rowM.getForeignRow("ID_CONTACT_FOURNISSEUR") == null || rowM.getForeignRow("ID_CONTACT_FOURNISSEUR").isUndefined()) continue;
                        mail = rowM.getForeignRow("ID_CONTACT_FOURNISSEUR").getString("EMAIL");
                    }
                }
            }
        }
        final String adresseMail = mail;
        final String subject = sheet.getReference();
        if (readOnly) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        final File f = sheet.getOrCreatePDFDocumentFile(true);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    EmailComposer.getInstance().compose(adresseMail, String.valueOf(subject) + (subject.trim().length() == 0 ? "" : ", ") + f.getName(), MouseSheetXmlListeListener.this.getMailObject(row), f.getAbsoluteFile());
                                }
                                catch (Exception e) {
                                    ExceptionHandler.handle("Impossible de charger le document PDF dans l'email!", e);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle("Impossible de charger le document PDF", e);
                    }
                }
            };
            t.start();
        } else {
            try {
                EmailComposer.getInstance().compose(adresseMail, String.valueOf(subject) + (subject.trim().length() == 0 ? "" : ", ") + sheet.getGeneratedFile().getName(), this.getMailObject(row), sheet.getGeneratedFile().getAbsoluteFile());
            }
            catch (Exception exn) {
                ExceptionHandler.handle(null, "Impossible de cr\u00e9er le courriel", exn);
            }
        }
    }

    public List<RowAction> addToMenu() {
        return null;
    }

    public List<RowAction> getRowActions() {
        List<RowAction> list;
        ArrayList<RowAction> l = new ArrayList<RowAction>();
        if (!Boolean.getBoolean("org.openconcerto.oo.useODSViewer")) {
            if (this.showIsVisible) {
                RowAction action = new RowAction(new AbstractAction(this.showString){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        System.err.println("");
                        MouseSheetXmlListeListener.this.createAbstractSheet(IListe.get(ev).getSelectedRow()).openDocument(false);
                    }
                }, this.previewHeader){

                    @Override
                    public boolean enabledFor(IListeAction.IListeEvent evt) {
                        return evt.getSelectedRow() != null && evt.getTotalRowCount() >= 1 && MouseSheetXmlListeListener.this.createAbstractSheet(evt.getSelectedRow().asRow()).getGeneratedFile().exists();
                    }
                };
                l.add(action);
            }
        } else if (this.previewIsVisible) {
            l.add(new RowAction(new AbstractAction(this.previewString){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    try {
                        MouseSheetXmlListeListener.this.createAbstractSheet(IListe.get(ev).getSelectedRow()).showPreviewDocument();
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle("Impossilbe d'ouvrir le fichier", e);
                    }
                }
            }, this.previewHeader){

                @Override
                public boolean enabledFor(IListeAction.IListeEvent evt) {
                    return evt.getSelectedRow() != null && evt.getTotalRowCount() >= 1 && MouseSheetXmlListeListener.this.createAbstractSheet(evt.getSelectedRow().asRow()).getGeneratedFile().exists();
                }
            });
        }
        if ((list = this.addToMenu()) != null) {
            for (RowAction rowAction : list) {
                l.add(rowAction);
            }
        }
        if (Boolean.getBoolean("org.openconcerto.oo.useODSViewer") && this.showIsVisible) {
            l.add(new RowAction(new AbstractAction(this.showString){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    MouseSheetXmlListeListener.this.createAbstractSheet(IListe.get(ev).getSelectedRow()).openDocument(false);
                }
            }, this.showHeader){

                @Override
                public boolean enabledFor(IListeAction.IListeEvent evt) {
                    return evt.getSelectedRow() != null && evt.getTotalRowCount() >= 1 && MouseSheetXmlListeListener.this.createAbstractSheet(evt.getSelectedRow().asRow()).getGeneratedFile().exists();
                }
            });
        }
        if (this.printIsVisible) {
            RowAction rowAction;
            l.add(new RowAction(new AbstractAction(this.fastPrintString){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    MouseSheetXmlListeListener.this.createAbstractSheet(IListe.get(ev).getSelectedRow()).fastPrintDocument();
                }
            }, this.printHeader){

                @Override
                public boolean enabledFor(IListeAction.IListeEvent evt) {
                    return evt.getSelectedRow() != null && evt.getTotalRowCount() >= 1 && MouseSheetXmlListeListener.this.createAbstractSheet(evt.getSelectedRow().asRow()).getGeneratedFile().exists();
                }
            });
            l.add(new RowAction(new AbstractAction(this.printString){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    MouseSheetXmlListeListener.this.createAbstractSheet(IListe.get(ev).getSelectedRow()).printDocument();
                }
            }, false){

                @Override
                public boolean enabledFor(IListeAction.IListeEvent evt) {
                    return evt.getSelectedRow() != null && evt.getTotalRowCount() >= 1 && MouseSheetXmlListeListener.this.createAbstractSheet(evt.getSelectedRow().asRow()).getGeneratedFile().exists();
                }
            });
            rowAction = new RowAction.PredicateRowAction(new AbstractAction(this.printAllString){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List<SQLRowAccessor> list = IListe.get(e).getSelectedRows();
                    ListeFastPrintFrame frame = new ListeFastPrintFrame(list, MouseSheetXmlListeListener.this.clazz);
                    frame.setVisible(true);
                }
            }, this.previewHeader);
            ((RowAction.PredicateRowAction)rowAction).setPredicate(IListeAction.IListeEvent.createSelectionCountPredicate(2, Integer.MAX_VALUE));
            l.add(rowAction);
        }
        if (this.showIsVisible) {
            l.add(new RowAction(new AbstractAction(this.mailPDFString){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    MouseSheetXmlListeListener.this.sendMail(MouseSheetXmlListeListener.this.createAbstractSheet(IListe.get(ev).getSelectedRow()), true);
                }
            }, false){

                @Override
                public boolean enabledFor(IListeAction.IListeEvent evt) {
                    return evt.getSelectedRow() != null && evt.getTotalRowCount() >= 1 && MouseSheetXmlListeListener.this.createAbstractSheet(evt.getSelectedRow().asRow()).getGeneratedFile().exists();
                }
            });
            l.add(new RowAction(new AbstractAction(this.mailString){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    MouseSheetXmlListeListener.this.sendMail(MouseSheetXmlListeListener.this.createAbstractSheet(IListe.get(ev).getSelectedRow()), false);
                }
            }, false){

                @Override
                public boolean enabledFor(IListeAction.IListeEvent evt) {
                    return evt.getSelectedRow() != null && evt.getTotalRowCount() >= 1 && MouseSheetXmlListeListener.this.createAbstractSheet(evt.getSelectedRow().asRow()).getGeneratedFile().exists();
                }
            });
        }
        if (this.generateIsVisible) {
            l.add(new RowAction(new AbstractAction(this.generateString){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    AbstractSheetXml sheet = MouseSheetXmlListeListener.this.createAbstractSheet(IListe.get(ev).getSelectedRow());
                    sheet.createDocumentAsynchronous();
                    sheet.showPrintAndExportAsynchronous(true, false, true);
                }
            }, this.generateHeader){

                @Override
                public boolean enabledFor(List<SQLRowAccessor> selection) {
                    return selection != null && selection.size() == 1;
                }
            });
        }
        return l;
    }
}

