/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationReglementVenteNG;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationMvtSaisieVenteFacture
extends GenerationEcritures
implements Runnable {
    public static final Integer journal = 3;
    private int idSaisieVenteFacture;
    private static final SQLTable saisieVFTable = base.getTable("SAISIE_VENTE_FACTURE");
    private static final SQLTable taxeTable = base.getTable("TAXE");
    private static final SQLTable mvtTable = base.getTable("MOUVEMENT");
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtSaisieVenteFacture(int idSaisieVenteFacture, int idMvt) {
        System.err.println("********* init GeneRation");
        this.idMvt = idMvt;
        this.idSaisieVenteFacture = idSaisieVenteFacture;
        new Thread(this).start();
    }

    public GenerationMvtSaisieVenteFacture(int idSaisieVenteFacture) {
        this.idMvt = 1;
        this.idSaisieVenteFacture = idSaisieVenteFacture;
        new Thread(this).start();
    }

    private void genereMouvement() throws IllegalArgumentException {
        SQLRow saisieRow = saisieVFTable.getRow(this.idSaisieVenteFacture);
        SQLRow clientRow = saisieRow.getForeignRow("ID_CLIENT");
        PrixTTC prixTTC = new PrixTTC((Long)saisieRow.getObject("T_TTC"));
        long montantAcompteTTC = 0L;
        PrixHT prixTVA = new PrixHT((Long)saisieRow.getObject("T_TVA"));
        PrixHT prixHT = new PrixHT((Long)saisieRow.getObject("T_HT"));
        PrixHT prixService = new PrixHT((Long)saisieRow.getObject("T_SERVICE"));
        int idCompteClient = clientRow.getInt("ID_COMPTE_PCE");
        this.date = (Date)saisieRow.getObject("DATE");
        Boolean acompte = saisieRow.getBoolean("ACOMPTE");
        this.nom = acompte != null && acompte != false ? "Fact. acompte client" + saisieRow.getObject("NUMERO").toString() : "Fact. vente " + saisieRow.getObject("NUMERO").toString();
        this.mEcritures.put("DATE", this.date);
        this.mEcritures.put("NOM", this.nom);
        this.mEcritures.put("ID_JOURNAL", journal);
        this.mEcritures.put("ID_MOUVEMENT", 1);
        if (this.idMvt == 1) {
            this.getNewMouvement("SAISIE_VENTE_FACTURE", this.idSaisieVenteFacture, 1, this.nom);
        } else {
            this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
            SQLRowValues rowValsPiece = mvtTable.getRow(this.idMvt).getForeign("ID_PIECE").asRowValues();
            rowValsPiece.put("NOM", this.nom);
            try {
                rowValsPiece.update();
            }
            catch (SQLException exn) {
                exn.printStackTrace();
            }
        }
        if (acompte == null || !acompte.booleanValue()) {
            int idCompteVenteProduit;
            long produitHT;
            int idCompteVenteService = saisieRow.getInt("ID_COMPTE_PCE_SERVICE");
            if (idCompteVenteService <= 1 && (idCompteVenteService = rowPrefsCompte.getInt("ID_COMPTE_PCE_VENTE_SERVICE")) <= 1) {
                try {
                    idCompteVenteService = ComptePCESQLElement.getIdComptePceDefault("VentesServices");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((produitHT = prixHT.getLongValue() - prixService.getLongValue()) >= 0L) {
                if (produitHT > 0L) {
                    idCompteVenteProduit = saisieRow.getInt("ID_COMPTE_PCE_VENTE");
                    if (idCompteVenteProduit <= 1 && (idCompteVenteProduit = rowPrefsCompte.getInt("ID_COMPTE_PCE_VENTE_PRODUIT")) <= 1) {
                        try {
                            idCompteVenteProduit = ComptePCESQLElement.getIdComptePceDefault("VentesProduits");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.mEcritures.put("ID_COMPTE_PCE", idCompteVenteProduit);
                    this.mEcritures.put("DEBIT", 0L);
                    this.mEcritures.put("CREDIT", produitHT);
                    int e = this.ajoutEcriture();
                }
                if (prixService.getLongValue() > 0L) {
                    this.mEcritures.put("ID_COMPTE_PCE", idCompteVenteService);
                    this.mEcritures.put("DEBIT", 0L);
                    this.mEcritures.put("CREDIT", prixService.getLongValue());
                    idCompteVenteProduit = this.ajoutEcriture();
                }
            } else {
                this.mEcritures.put("ID_COMPTE_PCE", idCompteVenteService);
                this.mEcritures.put("DEBIT", 0L);
                this.mEcritures.put("CREDIT", prixHT.getLongValue());
                idCompteVenteProduit = this.ajoutEcriture();
            }
            int idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_VENTE");
            if (prixTVA.getLongValue() > 0L) {
                if (idCompteTVA <= 1) {
                    try {
                        idCompteTVA = ComptePCESQLElement.getIdComptePceDefault("TVACollectee");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Map<Integer, Long> m = this.getMultiTVAFromRow(saisieRow, saisieVFTable.getTable("SAISIE_VENTE_FACTURE_ELEMENT"), true, prixHT, (Long)saisieRow.getObject("REMISE_HT"));
                long allTaxe = 0L;
                for (Integer i : m.keySet()) {
                    Long l = m.get(i);
                    if (l == null || l <= 0L) continue;
                    int idCpt = i;
                    if (idCpt <= 1) {
                        idCpt = idCompteTVA;
                    }
                    this.mEcritures.put("ID_COMPTE_PCE", idCpt);
                    this.mEcritures.put("DEBIT", 0L);
                    this.mEcritures.put("CREDIT", Long.valueOf(l));
                    this.ajoutEcriture();
                    allTaxe += l.longValue();
                }
                if (allTaxe < prixTVA.getLongValue()) {
                    this.mEcritures.put("ID_COMPTE_PCE", idCompteTVA);
                    this.mEcritures.put("DEBIT", 0L);
                    this.mEcritures.put("CREDIT", prixTVA.getLongValue() - allTaxe);
                    this.ajoutEcriture();
                }
            }
            if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                try {
                    idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mEcritures.put("ID_COMPTE_PCE", idCompteClient);
            this.mEcritures.put("DEBIT", prixTTC.getLongValue());
            this.mEcritures.put("CREDIT", 0L);
            this.ajoutEcriture();
        }
        SQLRow modeRegl = saisieRow.getForeignRow("ID_MODE_REGLEMENT");
        SQLRow typeRegRow = modeRegl.getForeignRow("ID_TYPE_REGLEMENT");
        String label = String.valueOf(this.nom) + " (" + typeRegRow.getString("NOM") + ")";
        int idAvoir = saisieRow.getInt("ID_AVOIR_CLIENT");
        if (idAvoir > 1) {
            long l = ((Number)saisieRow.getObject("T_AVOIR_TTC")).longValue();
            prixTTC = new PrixTTC((Long)saisieRow.getObject("T_TTC") - l);
        }
        if ((prixTTC = new PrixTTC(prixTTC.getLongValue() - montantAcompteTTC)).getLongValue() > 0L) {
            new GenerationReglementVenteNG(label, clientRow, prixTTC, this.date, modeRegl, saisieRow, mvtTable.getRow(this.idMvt));
        }
        SQLRowValues valSasieVF = new SQLRowValues(saisieVFTable);
        valSasieVF.put("ID_MOUVEMENT", (Object)this.idMvt);
        try {
            if (valSasieVF.getInvalid() == null) {
                valSasieVF.update(this.idSaisieVenteFacture);
            }
        }
        catch (SQLException e) {
            System.err.println("Erreur \u00e0 l'insertion dans la table " + valSasieVF.getTable().getName() + " : " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            System.err.println("****Start genere Mouvement");
            this.genereMouvement();
            System.err.println("****End genere Mouvement");
        }
        catch (IllegalArgumentException e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
            e.printStackTrace();
        }
    }
}

