/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;

public final class GenerationMvtFichePaye
extends GenerationEcritures
implements Runnable {
    private int[] idFichePaye;
    private String mois;
    private String annee;
    private static final SQLTable tableFichePaye = base.getTable("FICHE_PAYE");
    private static final SQLTable tableFichePayeElt = base.getTable("FICHE_PAYE_ELEMENT");
    private static final SQLTable tableSalarie = base.getTable("SALARIE");
    private static final SQLTable tableReglementPaye = base.getTable("REGLEMENT_PAYE");
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
    private static final Integer journalOD = 6;
    private Map<String, SQLTable> mapTableSource = new HashMap<String, SQLTable>();

    public GenerationMvtFichePaye(int[] idFichePaye, String mois, String annee) {
        SQLTable tableNet = Configuration.getInstance().getBase().getTable("RUBRIQUE_NET");
        SQLTable tableBrut = Configuration.getInstance().getBase().getTable("RUBRIQUE_BRUT");
        SQLTable tableCotis = Configuration.getInstance().getBase().getTable("RUBRIQUE_COTISATION");
        SQLTable tableComm = Configuration.getInstance().getBase().getTable("RUBRIQUE_COMM");
        this.mapTableSource.put(tableNet.getName(), tableNet);
        this.mapTableSource.put(tableBrut.getName(), tableBrut);
        this.mapTableSource.put(tableCotis.getName(), tableCotis);
        this.mapTableSource.put(tableComm.getName(), tableComm);
        this.idFichePaye = idFichePaye;
        this.annee = annee;
        this.mois = mois;
        this.idMvt = this.getNewMouvement("", 1, 1, "Paye " + this.mois + " " + this.annee);
        new Thread(this).start();
    }

    private void genereComptaFichePaye() throws IllegalArgumentException {
        Integer idCompte;
        SQLRow rowSal;
        SQLRow rowFiche;
        System.out.println("G\u00e9n\u00e9ration des ecritures  reglement du mouvement " + this.idMvt);
        this.date = new java.util.Date();
        this.nom = "Paye " + this.mois + " " + this.annee;
        this.mEcritures.put("DATE", new Date(this.date.getTime()));
        this.mEcritures.put("NOM", this.nom);
        this.mEcritures.put("ID_JOURNAL", journalOD);
        this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
        int i = 0;
        while (i < this.idFichePaye.length) {
            rowFiche = tableFichePaye.getRow(this.idFichePaye[i]);
            rowSal = tableSalarie.getRow(rowFiche.getInt("ID_SALARIE"));
            int idComptePaye = rowPrefsCompte.getInt("ID_COMPTE_PCE_PAYE");
            if (idComptePaye <= 1) {
                try {
                    idComptePaye = ComptePCESQLElement.getIdComptePceDefault("PayeRemunerationPersonnel");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mEcritures.put("ID_COMPTE_PCE", idComptePaye);
            this.mEcritures.put("NOM", String.valueOf(rowSal.getString("NOM")) + " " + this.nom);
            float sal = rowFiche.getFloat("SAL_BRUT");
            this.mEcritures.put("DEBIT", GestionDevise.parseLongCurrency(String.valueOf(sal)));
            this.mEcritures.put("CREDIT", 0L);
            this.ajoutEcriture();
            ++i;
        }
        i = 0;
        while (i < this.idFichePaye.length) {
            rowFiche = tableFichePaye.getRow(this.idFichePaye[i]);
            rowSal = tableSalarie.getRow(rowFiche.getInt("ID_SALARIE"));
            SQLRow rowRegl = tableReglementPaye.getRow(rowSal.getInt("ID_REGLEMENT_PAYE"));
            int idComptePayeRegl = rowRegl.getInt("ID_COMPTE_PCE");
            if (idComptePayeRegl <= 1) {
                try {
                    idComptePayeRegl = ComptePCESQLElement.getIdComptePceDefault("PayeReglement");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mEcritures.put("ID_COMPTE_PCE", idComptePayeRegl);
            this.mEcritures.put("NOM", String.valueOf(rowSal.getString("NOM")) + " " + this.nom);
            float sal = rowFiche.getFloat("SAL_BRUT");
            this.mEcritures.put("DEBIT", 0L);
            this.mEcritures.put("CREDIT", GestionDevise.parseLongCurrency(String.valueOf(sal)));
            this.ajoutEcriture();
            ++i;
        }
        i = 0;
        while (i < this.idFichePaye.length) {
            rowFiche = tableFichePaye.getRow(this.idFichePaye[i]);
            rowSal = tableSalarie.getRow(rowFiche.getInt("ID_SALARIE"));
            long acompte = GestionDevise.parseLongCurrency(String.valueOf(rowFiche.getFloat("ACOMPTE")));
            if (acompte != 0L) {
                int idCompteAcompte = rowPrefsCompte.getInt("ID_COMPTE_PCE_ACOMPTE");
                if (idCompteAcompte <= 1) {
                    try {
                        idCompteAcompte = ComptePCESQLElement.getIdComptePceDefault("PayeAcompte");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.mEcritures.put("ID_COMPTE_PCE", idCompteAcompte);
                this.mEcritures.put("NOM", String.valueOf(rowSal.getString("NOM")) + " Acompte sur " + this.nom);
                this.mEcritures.put("DEBIT", 0L);
                this.mEcritures.put("CREDIT", acompte);
                this.ajoutEcriture();
                SQLRow rowRegl = tableReglementPaye.getRow(rowSal.getInt("ID_REGLEMENT_PAYE"));
                int idComptePayeRegl = rowRegl.getInt("ID_COMPTE_PCE");
                if (idComptePayeRegl <= 1) {
                    try {
                        idComptePayeRegl = ComptePCESQLElement.getIdComptePceDefault("PayeReglement");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.mEcritures.put("ID_COMPTE_PCE", idComptePayeRegl);
                this.mEcritures.put("NOM", String.valueOf(rowSal.getString("NOM")) + " Acompte sur " + this.nom);
                this.mEcritures.put("DEBIT", acompte);
                this.mEcritures.put("CREDIT", 0L);
                this.ajoutEcriture();
            }
            ++i;
        }
        SQLSelect selAllIDFicheElt = new SQLSelect(base);
        selAllIDFicheElt.addSelect(tableFichePayeElt.getField("ID"));
        Where w = null;
        int i2 = 0;
        while (i2 < this.idFichePaye.length) {
            if (w == null) {
                w = new Where((FieldRef)tableFichePayeElt.getField("ID_FICHE_PAYE"), "=", this.idFichePaye[i2]);
            } else {
                w.and(new Where((FieldRef)tableFichePayeElt.getField("ID_FICHE_PAYE"), "=", this.idFichePaye[i2]));
            }
            ++i2;
        }
        selAllIDFicheElt.setWhere(w);
        selAllIDFicheElt.setDistinct(true);
        String reqAllIDFichelElt = selAllIDFicheElt.asString();
        System.err.println("Request " + reqAllIDFichelElt);
        Object[] objIDFicheElt = ((List)base.getDataSource().execute(reqAllIDFichelElt, new ArrayListHandler())).toArray();
        System.err.println(String.valueOf(objIDFicheElt.length) + " elements to load");
        HashMap<Integer, Long> mapCompteDebSal = new HashMap<Integer, Long>();
        HashMap<Integer, Long> mapCompteDebPat = new HashMap<Integer, Long>();
        HashMap<Integer, Long> mapCompteCredSal = new HashMap<Integer, Long>();
        HashMap<Integer, Long> mapCompteCredPat = new HashMap<Integer, Long>();
        int i3 = 0;
        while (i3 < objIDFicheElt.length) {
            SQLRow row = tableFichePayeElt.getRow(Integer.parseInt(((Object[])objIDFicheElt[i3])[0].toString()));
            String source = row.getString("SOURCE");
            int idSource = row.getInt("IDSOURCE");
            if (source.trim().length() != 0) {
                System.err.println("Source != null");
                if (this.mapTableSource.get(source) != null) {
                    SQLRow rowSource = this.mapTableSource.get(source).getRow(idSource);
                    if (rowSource.getTable().getName().equalsIgnoreCase("RUBRIQUE_COTISATION")) {
                        int idCompteCharge = ComptePCESQLElement.getId("645");
                        int idCompteTiers = ComptePCESQLElement.getId("437");
                        if (row.getFloat("MONTANT_SAL_DED") != 0.0f) {
                            Object montantCredObj = mapCompteCredSal.get(idCompteTiers);
                            long montantCred = montantCredObj == null ? 0L : (Long)montantCredObj;
                            mapCompteCredSal.put(idCompteTiers, montantCred += GestionDevise.parseLongCurrency(row.getObject("MONTANT_SAL_DED").toString()));
                            Object montantDebObj = mapCompteDebSal.get(ComptePCESQLElement.getId("421"));
                            long montantDeb = montantDebObj == null ? 0L : (Long)montantDebObj;
                            mapCompteDebSal.put(ComptePCESQLElement.getId("421"), montantDeb += GestionDevise.parseLongCurrency(row.getObject("MONTANT_SAL_DED").toString()));
                        }
                        if (row.getFloat("MONTANT_PAT") != 0.0f) {
                            Object montantDebObj = mapCompteDebPat.get(idCompteCharge);
                            long montantDeb = montantDebObj == null ? 0L : (Long)montantDebObj;
                            mapCompteDebPat.put(idCompteCharge, montantDeb += GestionDevise.parseLongCurrency(row.getObject("MONTANT_PAT").toString()));
                            Object montantCredObj = mapCompteCredPat.get(idCompteTiers);
                            long montantCred = montantCredObj == null ? 0L : (Long)montantCredObj;
                            mapCompteCredPat.put(idCompteTiers, montantCred += GestionDevise.parseLongCurrency(row.getObject("MONTANT_PAT").toString()));
                        }
                    }
                } else {
                    System.err.println("Table " + source + " non r\u00e9f\u00e9renc\u00e9e");
                }
            }
            ++i3;
        }
        for (Map.Entry entry : mapCompteCredSal.entrySet()) {
            idCompte = (Integer)entry.getKey();
            this.mEcritures.put("ID_COMPTE_PCE", idCompte);
            this.mEcritures.put("NOM", "Cotisations salariales, " + this.nom);
            this.mEcritures.put("DEBIT", 0L);
            this.mEcritures.put("CREDIT", entry.getValue());
            this.ajoutEcriture();
        }
        for (Map.Entry entry : mapCompteDebSal.entrySet()) {
            idCompte = (Integer)entry.getKey();
            this.mEcritures.put("ID_COMPTE_PCE", idCompte);
            this.mEcritures.put("NOM", "Cotisations salariales, " + this.nom);
            this.mEcritures.put("CREDIT", 0L);
            this.mEcritures.put("DEBIT", entry.getValue());
            this.ajoutEcriture();
        }
        for (Map.Entry entry : mapCompteCredPat.entrySet()) {
            idCompte = (Integer)entry.getKey();
            this.mEcritures.put("ID_COMPTE_PCE", idCompte);
            this.mEcritures.put("NOM", "Cotisations patronales, " + this.nom);
            this.mEcritures.put("DEBIT", 0L);
            this.mEcritures.put("CREDIT", entry.getValue());
            this.ajoutEcriture();
        }
        for (Map.Entry entry : mapCompteDebPat.entrySet()) {
            idCompte = (Integer)entry.getKey();
            this.mEcritures.put("ID_COMPTE_PCE", idCompte);
            this.mEcritures.put("NOM", "Cotisations patronales, " + this.nom);
            this.mEcritures.put("CREDIT", 0L);
            this.mEcritures.put("DEBIT", entry.getValue());
            this.ajoutEcriture();
        }
    }

    @Override
    public void run() {
        try {
            this.genereComptaFichePaye();
        }
        catch (IllegalArgumentException e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
            e.printStackTrace();
        }
    }
}

