/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationEcritures {
    protected static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private static final SQLTable compteTable = base.getTable("COMPTE_PCE");
    private static final SQLTable journalTable = base.getTable("JOURNAL");
    private static final SQLTable ecritureTable = base.getTable("ECRITURE");
    private static final SQLTable pieceTable = base.getTable("PIECE");
    protected int idMvt;
    protected int idPiece;
    protected Date date;
    protected String nom;
    public Map<String, Object> mEcritures = new HashMap<String, Object>();

    public synchronized int ajoutEcriture() throws IllegalArgumentException {
        Number n2;
        long debit = (Long)this.mEcritures.get("DEBIT");
        long credit = (Long)this.mEcritures.get("CREDIT");
        Number n = (Number)this.mEcritures.get("ID_JOURNAL");
        if (n != null) {
            SQLRow rowJrnl = journalTable.getRow(n.intValue());
            this.mEcritures.put("JOURNAL_NOM", rowJrnl.getString("NOM"));
            this.mEcritures.put("JOURNAL_CODE", rowJrnl.getString("CODE"));
        }
        if ((n2 = (Number)this.mEcritures.get("ID_COMPTE_PCE")) != null) {
            SQLRow rowCpt = compteTable.getRow(n2.intValue());
            this.mEcritures.put("COMPTE_NUMERO", rowCpt.getString("NUMERO"));
            this.mEcritures.put("COMPTE_NOM", rowCpt.getString("NOM"));
        }
        if (debit != 0L && credit != 0L) {
            throw new IllegalArgumentException("Le d\u00e9bit et le cr\u00e9dit ne peuvent pas \u00eatre tous les 2 diff\u00e9rents de 0. Debit : " + debit + " Credit : " + credit);
        }
        if (debit < 0L) {
            credit = -debit;
            debit = 0L;
        }
        if (credit < 0L) {
            debit = -credit;
            credit = 0L;
        }
        this.mEcritures.put("DEBIT", debit);
        this.mEcritures.put("CREDIT", credit);
        Date d = (Date)this.mEcritures.get("DATE");
        SQLTable tableExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON");
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        SQLRow rowExercice = tableExercice.getRow(rowSociete.getInt("ID_EXERCICE_COMMON"));
        Date dDebEx = (Date)rowExercice.getObject("DATE_DEB");
        Date dCloture = (Date)rowExercice.getObject("DATE_CLOTURE");
        if (dCloture != null) {
            if (dCloture.after(d)) {
                System.err.println("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
                throw new IllegalArgumentException("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
            }
        } else if (dDebEx.after(d)) {
            System.err.println("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
            throw new IllegalArgumentException("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
        }
        SQLRowValues valEcriture = new SQLRowValues(ecritureTable, this.mEcritures);
        valEcriture.put("IDUSER_CREATE", UserManager.getInstance().getCurrentUser().getId());
        try {
            if (valEcriture.getInvalid() == null) {
                SQLRow ecritureRow = valEcriture.insert();
                return ecritureRow.getID();
            }
            System.err.println("GenerationEcritures.java :: Error in values for insert in table " + ecritureTable.getName() + " : " + valEcriture.toString());
            throw new IllegalArgumentException("Erreur lors de la g\u00e9n\u00e9ration des \u00e9critures donn\u00e9es incorrectes. " + valEcriture);
        }
        catch (SQLException e) {
            System.err.println("Error insert row in " + ecritureTable.getName() + " : " + e);
            final SQLException eFinal = e;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration des \u00e9critures.", eFinal);
                }
            });
            e.printStackTrace();
            return -1;
        }
    }

    public synchronized int getNewMouvement(String source, int idSource, int idPere, String nomPiece) {
        SQLRowValues rowValsPiece = new SQLRowValues(pieceTable);
        rowValsPiece.put("NOM", nomPiece);
        try {
            SQLRow rowPiece = rowValsPiece.insert();
            return this.getNewMouvement(source, idSource, idPere, rowPiece.getID());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 1;
        }
    }

    protected Map<Integer, Long> getMultiTVAFromRow(SQLRow row, SQLTable foreign, boolean vente, PrixHT totalHt, long remiseHT) {
        SQLRow taxePort;
        long port;
        Collection rows = row.getReferentRows(foreign);
        HashMap<SQLRow, Long> mapTaxeHT = new HashMap<SQLRow, Long>();
        for (SQLRow sqlRow : rows) {
            SQLRow taxe = sqlRow.getForeignRow("ID_TAXE");
            long val = sqlRow.getLong("T_PV_HT");
            Long l = (Long)mapTaxeHT.get(taxe);
            if (l == null) {
                mapTaxeHT.put(taxe, val);
                continue;
            }
            mapTaxeHT.put(taxe, val + l);
        }
        if (row.getTable().contains("ID_TAXE_PORT") && (port = row.getLong("PORT_HT")) > 0L && (taxePort = row.getForeignRow("ID_TAXE_PORT")) != null && !taxePort.isUndefined()) {
            if (mapTaxeHT.get(taxePort) == null) {
                mapTaxeHT.put(taxePort, port);
            } else {
                Long l = (Long)mapTaxeHT.get(taxePort);
                mapTaxeHT.put(taxePort, l + port);
            }
        }
        long totalHTAvantRemise = totalHt.getLongValue() + remiseHT;
        long remiseToApply = remiseHT;
        if (remiseToApply > 0L) {
            Set setHtTVA = mapTaxeHT.keySet();
            int i = 0;
            for (SQLRow rowA : mapTaxeHT.keySet()) {
                Long ht = (Long)mapTaxeHT.get(rowA);
                if (++i == setHtTVA.size()) {
                    mapTaxeHT.put(rowA, ht - remiseToApply);
                    continue;
                }
                long r = new BigDecimal(ht).divide(new BigDecimal(totalHTAvantRemise), MathContext.DECIMAL128).multiply(new BigDecimal(remiseHT)).setScale(0, 4).longValue();
                mapTaxeHT.put(rowA, ht - r);
                remiseToApply -= r;
            }
        }
        HashMap<Integer, Long> map = new HashMap<Integer, Long>();
        for (SQLRow sqlRow : mapTaxeHT.keySet()) {
            BigDecimal d = new BigDecimal(sqlRow.getFloat("TAUX"));
            BigDecimal result = d.multiply(new BigDecimal((Long)mapTaxeHT.get(sqlRow)), MathContext.DECIMAL128).movePointLeft(2);
            int compte = vente ? sqlRow.getInt("ID_COMPTE_PCE_COLLECTE") : sqlRow.getInt("ID_COMPTE_PCE_DED");
            map.put(compte, result.setScale(0, 4).longValue());
        }
        return map;
    }

    public synchronized int getNewMouvement(String source, int idSource, int idPere, int idPiece) {
        SQLTable mouvementTable = base.getTable("MOUVEMENT");
        SQLSelect selNumMvt = new SQLSelect(base);
        selNumMvt.addSelect(mouvementTable.getField("NUMERO"));
        String reqNumMvt = selNumMvt.asString();
        Object obNumMvt = base.getDataSource().execute(reqNumMvt, new ArrayListHandler());
        List myListNumMvt = (List)obNumMvt;
        int numMvt = 1;
        if (myListNumMvt.size() != 0) {
            int i = 0;
            while (i < myListNumMvt.size()) {
                Object[] objTmp = (Object[])myListNumMvt.get(i);
                int tmp = Integer.parseInt(objTmp[0].toString());
                if (numMvt < tmp) {
                    numMvt = tmp;
                }
                ++i;
            }
        }
        ++numMvt;
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("SOURCE", source);
        m.put("IDSOURCE", idSource);
        m.put("ID_MOUVEMENT_PERE", idPere);
        this.idPiece = idPiece;
        m.put("ID_PIECE", idPiece);
        m.put("NUMERO", numMvt);
        SQLRowValues val = new SQLRowValues(mouvementTable, m);
        try {
            if (val.getInvalid() == null) {
                SQLRow row = val.insert();
                this.idMvt = row.getID();
                this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
            } else {
                System.err.println("Error in values for insert in table " + val.getTable().getName() + " : " + val.toString());
            }
        }
        catch (SQLException e) {
            System.err.println("Error insert row in " + val.getTable().getName());
            e.printStackTrace();
        }
        System.err.println("Numero de mouvement g\u00e9n\u00e9r\u00e9 : " + numMvt);
        return this.idMvt;
    }
}

