/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.product.component.ReferenceArticleSQLComponent;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class ReferenceArticleSQLElement
extends ComptaSQLConfElement {
    public ReferenceArticleSQLElement() {
        super("ARTICLE", "un article", "articles");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        String articleAdvanced = DefaultNXProps.getInstance().getStringProperty("ArticleModeVenteAvance");
        Boolean bArticleAdvanced = Boolean.valueOf(articleAdvanced);
        if (bArticleAdvanced.booleanValue()) {
            l.add("POIDS");
            l.add("PRIX_METRIQUE_HA_1");
            l.add("PRIX_METRIQUE_VT_1");
        }
        l.add("PA_HT");
        l.add("PV_HT");
        l.add("ID_TAXE");
        l.add("PV_TTC");
        l.add("ID_FAMILLE_ARTICLE");
        l.add("ID_FOURNISSEUR");
        l.add("ID_STOCK");
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean b = Boolean.valueOf(val);
        if (b != null && b.booleanValue()) {
            l.add("SERVICE");
        }
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        return l;
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_STOCK");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new ReferenceArticleSQLComponent(this);
    }

    public static long getPrixHAFromDetails(SQLRowValues rowVals) {
        return ReferenceArticleSQLElement.getValuePiece(rowVals, 1);
    }

    public static long getPrixVTFromDetails(SQLRowValues rowVals) {
        return ReferenceArticleSQLElement.getValuePiece(rowVals, 2);
    }

    public static float getPoidsFromDetails(SQLRowValues rowVals) {
        float valMetrique3;
        float valMetrique2;
        float valMetrique1 = rowVals.getObject("VALEUR_METRIQUE_1") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_1");
        float produit = valMetrique1 * (valMetrique2 = rowVals.getObject("VALEUR_METRIQUE_2") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_2")) * (valMetrique3 = rowVals.getObject("VALEUR_METRIQUE_3") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_3"));
        if (produit > 0.0f) {
            return (float)Math.round(produit * 1000.0f) / 1000.0f;
        }
        if (rowVals.getObject("POIDS") != null) {
            float p = rowVals.getFloat("POIDS");
            return p;
        }
        return 0.0f;
    }

    private static long getValuePiece(SQLRowValues rowVals, int value) {
        float valMetrique3;
        if (rowVals.getObject("ID_MODE_VENTE_ARTICLE") == null) {
            throw new IllegalArgumentException("La SQLRowValues ne contient pas ID_MODE_VENTE_ARTICLE");
        }
        int mode = rowVals.getInt("ID_MODE_VENTE_ARTICLE");
        if (mode == 1) {
            mode = 5;
        }
        long metrique1HA = rowVals.getObject("PRIX_METRIQUE_HA_1") == null ? 0L : (Long)rowVals.getObject("PRIX_METRIQUE_HA_1");
        long metrique1VT = rowVals.getObject("PRIX_METRIQUE_VT_1") == null ? 0L : (Long)rowVals.getObject("PRIX_METRIQUE_VT_1");
        float valMetrique1 = rowVals.getObject("VALEUR_METRIQUE_1") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_1");
        float valMetrique2 = rowVals.getObject("VALEUR_METRIQUE_2") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_2");
        float f = valMetrique3 = rowVals.getObject("VALEUR_METRIQUE_3") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_3");
        if (mode == 5) {
            if (value == 1) {
                if (rowVals.getObject("PA_HT") != null) {
                    long l = rowVals.getLong("PA_HT");
                    return l;
                }
                return 0L;
            }
            if (rowVals.getObject("PV_HT") != null) {
                long l = rowVals.getLong("PV_HT");
                return l;
            }
            return 0L;
        }
        if (mode == 3) {
            float surface = valMetrique1 * valMetrique2;
            if (value == 1) {
                return (long)((float)metrique1HA * surface);
            }
            return (long)((float)metrique1VT * surface);
        }
        if (mode == 6) {
            if (value == 1) {
                return (long)((float)metrique1HA * valMetrique2);
            }
            return (long)((float)metrique1VT * valMetrique2);
        }
        if (mode == 2) {
            if (value == 1) {
                return (long)((float)metrique1HA * valMetrique1);
            }
            return (long)((float)metrique1VT * valMetrique1);
        }
        if (mode == 4) {
            float surface = valMetrique1 * valMetrique2;
            float p = surface * valMetrique3;
            if (value == 1) {
                return (long)((float)metrique1HA * p);
            }
            return (long)((float)metrique1VT * p);
        }
        throw new IllegalStateException("Unknown mode:" + mode);
    }

    public static int getIdForCNM(SQLRowValues row, boolean createIfNotExist) {
        return ReferenceArticleSQLElement.getIdFor(row, true, createIfNotExist);
    }

    public static int getIdForCN(SQLRowValues row, boolean createIfNotExist) {
        return ReferenceArticleSQLElement.getIdFor(row, false, createIfNotExist);
    }

    private static int getIdFor(SQLRowValues row, boolean includeMetrique, boolean createIfNotExist) {
        SQLTable tableArt = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement(tableArt);
        String req = ReferenceArticleSQLElement.getMatchRequest(row, includeMetrique);
        List result = (List)eltArticle.getTable().getBase().getDataSource().execute(req, new ArrayListHandler());
        if (result != null && result.size() != 0) {
            Object[] tmp = (Object[])result.get(0);
            return ((Number)tmp[0]).intValue();
        }
        if (createIfNotExist) {
            SQLRowValues vals = new SQLRowValues(row);
            try {
                SQLRow rowNew = vals.insert();
                return rowNew.getID();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    private static String getMatchRequest(SQLRowValues row, boolean includeMetrique) {
        SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement(sqlTableArticle);
        SQLSelect sel = new SQLSelect(eltArticle.getTable().getBase());
        sel.addSelect(eltArticle.getTable().getField("ID"));
        Where w = new Where((FieldRef)eltArticle.getTable().getField("CODE"), "=", (Object)row.getString("CODE"));
        if (includeMetrique) {
            float value1 = ((Number)row.getObject("VALEUR_METRIQUE_1")).floatValue();
            float value2 = ((Number)row.getObject("VALEUR_METRIQUE_2")).floatValue();
            float value3 = ((Number)row.getObject("VALEUR_METRIQUE_3")).floatValue();
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_1"), "<=", (Object)new Float((double)value1 + 1.0E-5)));
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_1"), ">=", (Object)new Float((double)value1 - 1.0E-5)));
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_2"), "<=", (Object)new Float((double)value2 + 1.0E-5)));
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_2"), ">=", (Object)new Float((double)value2 - 1.0E-5)));
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_3"), "<=", (Object)new Float((double)value3 + 1.0E-5)));
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_3"), ">=", (Object)new Float((double)value3 - 1.0E-5)));
        }
        sel.setWhere(w);
        return sel.asString();
    }

    public static boolean isReferenceEquals(SQLRowValues rowVals1, SQLRowValues rowVals2) {
        return rowVals1.getObject("CODE").equals(rowVals2.getObject("CODE")) && rowVals1.getString("VALEUR_METRIQUE_1").equals(rowVals2.getString("VALEUR_METRIQUE_1")) && rowVals1.getString("VALEUR_METRIQUE_2").equals(rowVals2.getString("VALEUR_METRIQUE_2")) && rowVals1.getString("VALEUR_METRIQUE_3").equals(rowVals2.getString("VALEUR_METRIQUE_3"));
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".ref";
    }
}

