/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.erp.core.sales.pos.ui.ArticleModel;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.erp.core.sales.pos.ui.StatusBar;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.ui.touch.ScrollableList;

public class ArticleSelector
extends JPanel
implements ListSelectionListener,
CaisseListener {
    private ArticleModel model;
    private ScrollableList list;
    private StatusBar comp;
    private CaisseControler controller;

    ArticleSelector(final CaisseControler controller) {
        this.controller = controller;
        this.controller.addCaisseListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 1;
        this.comp = new StatusBar();
        this.comp.setTitle("Articles");
        this.add((Component)this.comp, c);
        c.weighty = 1.0;
        ++c.gridy;
        this.model = new ArticleModel();
        this.model.setCategorie(null);
        final Font f = new Font("Arial", 0, 24);
        this.list = new ScrollableList(this.model){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.setColor(Color.GRAY);
                g.drawLine(0, 0, 0, this.getHeight());
            }

            @Override
            public void paintCell(Graphics g, Object object, int index, boolean isSelected, int posY) {
                g.setFont(f);
                if (isSelected) {
                    g.setColor(new Color(232, 242, 254));
                } else {
                    g.setColor(Color.WHITE);
                }
                g.fillRect(0, posY, this.getWidth(), this.getCellHeight());
                g.setColor(Color.GRAY);
                g.drawLine(0, posY + this.getCellHeight() - 1, this.getWidth(), posY + this.getCellHeight() - 1);
                if (isSelected) {
                    g.setColor(Color.BLACK);
                } else {
                    g.setColor(Color.GRAY);
                }
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Article article = (Article)object;
                String label = article.getName();
                int MAX_WIDTH = 18;
                if (label.length() > 36) {
                    label = String.valueOf(label.substring(0, 36)) + "...";
                }
                String label2 = null;
                if (label.length() > 18) {
                    String t = label.substring(0, 18).trim();
                    int lastSpace = t.lastIndexOf(32);
                    if (lastSpace <= 0) {
                        lastSpace = 18;
                    }
                    label2 = label.substring(lastSpace).trim();
                    label = label.substring(0, lastSpace).trim();
                    if (label2.length() > 18) {
                        label2 = String.valueOf(label2.substring(0, 18)) + "...";
                    }
                }
                String euro = String.valueOf(TicketCellRenderer.centsToString(article.getPriceInCents())) + "\u20ac";
                int wEuro = (int)g.getFontMetrics().getStringBounds(euro, g).getWidth();
                if (label2 == null) {
                    g.drawString(label, 10, posY + 39);
                } else {
                    g.drawString(label, 10, posY + 26);
                    g.drawString(label2, 10, posY + 52);
                }
                g.drawString(euro, this.getWidth() - 5 - wEuro, posY + 39);
            }
        };
        this.list.setFixedCellHeight(64);
        this.list.setOpaque(true);
        this.add((Component)this.list, c);
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object sel;
                int nb = e.getClickCount();
                if (nb > 1 && (sel = ArticleSelector.this.list.getSelectedValue()) != null) {
                    Article article = (Article)sel;
                    controller.incrementArticle(article);
                    controller.setArticleSelected(article);
                }
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object sel = this.list.getSelectedValue();
        if (sel != null && !e.getValueIsAdjusting()) {
            Article article = (Article)sel;
            this.controller.addArticle(article);
            this.controller.setArticleSelected(article);
        }
    }

    public ArticleModel getModel() {
        return this.model;
    }

    @Override
    public void caisseStateChanged() {
        Article articleSelected = this.controller.getArticleSelected();
        if (articleSelected == null) {
            return;
        }
        Object selectedValue = null;
        try {
            selectedValue = this.list.getSelectedValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (articleSelected != null && !articleSelected.equals(selectedValue)) {
            Categorie c = articleSelected.getCategorie();
            this.model.setCategorie(c);
            this.list.setSelectedValue(articleSelected, true);
        }
    }
}

