/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.ComponentsContext;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleVersion;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.DirectedEdge;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.utils.ThreadFactory;
import org.openconcerto.utils.Tuple2;

public class ModuleManager {
    private static final Logger L = Logger.getLogger(ModuleManager.class.getPackage().getName());
    private static final Executor exec = new ThreadPoolExecutor(0, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(String.valueOf(ModuleManager.class.getSimpleName()) + " executor thread ", Boolean.TRUE));
    private static final String FWK_MODULE_TABLENAME = new String("FWK_MODULE_METADATA");
    private static final String fileMutex = new String("modules");
    private static ModuleManager instance = null;
    private final Map<String, ModuleFactory> factories = new HashMap<String, ModuleFactory>();
    private final Map<String, AbstractModule> runningModules = new HashMap<String, AbstractModule>();
    private final Map<String, Collection<SQLElement>> modulesElements;
    private final Map<String, ComponentsContext> modulesComponents;
    private final DirectedGraph<ModuleFactory, DirectedEdge<ModuleFactory>> dependencyGraph = new SimpleDirectedGraph<ModuleFactory, DirectedEdge<ModuleFactory>>(new EdgeFactory<ModuleFactory, DirectedEdge<ModuleFactory>>(){});
    private DBRoot root = null;
    private Configuration conf = null;

    public ModuleManager() {
        this.modulesElements = new HashMap<String, Collection<SQLElement>>();
        this.modulesComponents = new HashMap<String, ComponentsContext>();
    }

    public final synchronized void setRoot(DBRoot root) {
        if (this.root != root) {
            if (this.root != null) {
                throw new IllegalStateException("Root already set");
            }
            this.root = root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLTable getInstalledTable(DBRoot r) throws SQLException {
        String string = FWK_MODULE_TABLENAME;
        synchronized (string) {
            if (!r.contains(FWK_MODULE_TABLENAME)) {
                SQLCreateTable createTable = new SQLCreateTable(r, FWK_MODULE_TABLENAME);
                createTable.setPlain(true);
                createTable.addColumn("ID", createTable.getSyntax().getPrimaryIDDefinition());
                createTable.addVarCharColumn("MODULE_NAME", 128);
                createTable.addColumn("TABLE", "varchar(128) NULL");
                createTable.addColumn("FIELD", "varchar(128) NULL");
                createTable.addColumn("KEY", "boolean NULL");
                createTable.addColumn("MODULE_VERSION", "bigint NOT NULL");
                createTable.addUniqueConstraint("uniqModule", Arrays.asList("MODULE_NAME", "TABLE", "FIELD"));
                r.createTable(createTable);
            }
        }
        return r.getTable(FWK_MODULE_TABLENAME);
    }

    public final synchronized DBRoot getRoot() {
        return this.root;
    }

    public final Map<String, ModuleVersion> getDBInstalledModules() throws SQLException {
        return this.getDBInstalledModules(null);
    }

    private final Map<String, ModuleVersion> getDBInstalledModules(String id) throws SQLException {
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        SQLSelect sel = new SQLSelect(installedTable.getBase()).addSelectStar(installedTable);
        sel.setWhere(Where.isNull(installedTable.getField("TABLE")).and(Where.isNull(installedTable.getField("FIELD"))));
        if (id != null) {
            sel.andWhere(new Where((FieldRef)installedTable.getField("MODULE_NAME"), "=", (Object)id));
        }
        HashMap<String, ModuleVersion> res = new HashMap<String, ModuleVersion>();
        for (SQLRow r : SQLRowListRSH.execute(sel)) {
            res.put(r.getString("MODULE_NAME"), new ModuleVersion(r.getLong("MODULE_VERSION")));
        }
        return res;
    }

    public final Tuple2<Set<String>, Set<SQLName>> getCreatedItems(String id) throws SQLException {
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        SQLSelect sel = new SQLSelect(installedTable.getBase());
        sel.addSelect(installedTable.getKey());
        sel.addSelect(installedTable.getField("TABLE"));
        sel.addSelect(installedTable.getField("FIELD"));
        sel.setWhere(new Where((FieldRef)installedTable.getField("MODULE_NAME"), "=", (Object)id).and(Where.isNotNull(installedTable.getField("TABLE"))));
        HashSet<String> tables = new HashSet<String>();
        HashSet<SQLName> fields = new HashSet<SQLName>();
        for (SQLRow r : SQLRowListRSH.execute(sel)) {
            String tableName = r.getString("TABLE");
            String fieldName = r.getString("FIELD");
            if (fieldName == null) {
                tables.add(tableName);
                continue;
            }
            fields.add(new SQLName(tableName, fieldName));
        }
        return Tuple2.create(tables, fields);
    }
}

