/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.util.Utils;

public class AlterUser
extends DefineCommand {
    private int type;
    private User user;
    private String newName;
    private Expression password;
    private Expression salt;
    private Expression hash;
    private boolean admin;

    public AlterUser(Session session) {
        super(session);
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setNewName(String string) {
        this.newName = string;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setAdmin(boolean bl) {
        this.admin = bl;
    }

    public void setSalt(Expression expression) {
        this.salt = expression;
    }

    public void setHash(Expression expression) {
        this.hash = expression;
    }

    public void setPassword(Expression expression) {
        this.password = expression;
    }

    private char[] getCharArray(Expression expression) {
        return expression.optimize(this.session).getValue(this.session).getString().toCharArray();
    }

    private byte[] getByteArray(Expression expression) {
        return Utils.convertStringToBytes(expression.optimize(this.session).getValue(this.session).getString());
    }

    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        switch (this.type) {
            case 0: {
                if (this.user != this.session.getUser()) {
                    this.session.getUser().checkAdmin();
                }
                if (this.hash != null && this.salt != null) {
                    this.user.setSaltAndHash(this.getByteArray(this.salt), this.getByteArray(this.hash));
                    break;
                }
                String string = this.newName == null ? this.user.getName() : this.newName;
                SHA256 sHA256 = new SHA256();
                char[] cArray = this.getCharArray(this.password);
                byte[] byArray = sHA256.getKeyPasswordHash(string, cArray);
                this.user.setUserPasswordHash(byArray);
                break;
            }
            case 1: {
                this.session.getUser().checkAdmin();
                if (database.findUser(this.newName) != null || this.newName.equals(this.user.getName())) {
                    throw DbException.get(90033, this.newName);
                }
                database.renameDatabaseObject(this.session, this.user, this.newName);
                break;
            }
            case 2: {
                this.session.getUser().checkAdmin();
                if (!this.admin) {
                    this.user.checkOwnsNoSchemas();
                }
                this.user.setAdmin(this.admin);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        database.update(this.session, this.user);
        return 0;
    }
}

